/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.learning;

import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.Solver;
import org.sat4j.minisat.learning.LimitedLearning;
import org.sat4j.minisat.learning.MiniSATLearning;
import org.sat4j.minisat.learning.NoLearningNoHeuristics;

public class FixedLengthLearning
extends LimitedLearning {
    private static final long serialVersionUID = 1L;
    private final int maxlength;
    private final NoLearningNoHeuristics none;
    private final MiniSATLearning all;

    public FixedLengthLearning(int n) {
        this.maxlength = n;
        this.none = new NoLearningNoHeuristics();
        this.all = new MiniSATLearning();
    }

    public void setSolver(Solver solver) {
        this.all.setDataStructureFactory(solver.getDSFactory());
    }

    public void learns(Constr constr) {
        if (this.learningCondition(constr)) {
            this.all.learns(constr);
        } else {
            this.none.learns(constr);
        }
    }

    protected boolean learningCondition(Constr constr) {
        return constr.size() <= this.maxlength;
    }
}

