/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.learning;

import java.io.Serializable;
import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.LearningStrategy;
import org.sat4j.minisat.core.Solver;
import org.sat4j.minisat.learning.MiniSATLearning;
import org.sat4j.minisat.learning.NoLearningButHeuristics;

public class LimitedLearning
implements LearningStrategy,
Serializable {
    private static final long serialVersionUID = 1L;
    private final NoLearningButHeuristics none = new NoLearningButHeuristics();
    private final MiniSATLearning all = new MiniSATLearning();
    private final int maxpercent;
    private ILits lits;

    public LimitedLearning() {
        this(10);
    }

    public LimitedLearning(int n) {
        this.maxpercent = n;
    }

    public void setSolver(Solver solver) {
        this.lits = solver.getVocabulary();
        this.none.setVarActivityListener(solver);
        this.all.setDataStructureFactory(solver.getDSFactory());
    }

    public void learns(Constr constr) {
        if (this.learningCondition(constr)) {
            this.all.learns(constr);
        } else {
            this.none.learns(constr);
        }
    }

    protected boolean learningCondition(Constr constr) {
        return constr.size() <= this.lits.nVars() * this.maxpercent / 100;
    }
}

