/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.reader;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Serializable;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.reader.Reader;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.VecInt;

public class DimacsReader
implements Reader,
Serializable {
    private static final long serialVersionUID = 1L;
    private int expectedNbOfClauses;
    private final ISolver solver;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DimacsReader(ISolver iSolver) {
        this.solver = iSolver;
    }

    protected void skipComments(LineNumberReader lineNumberReader) throws IOException {
        int n;
        do {
            lineNumberReader.mark(4);
            n = lineNumberReader.read();
            if (n == 99) {
                lineNumberReader.readLine();
                continue;
            }
            lineNumberReader.reset();
        } while (n == 99);
    }

    protected void readProblemLine(LineNumberReader lineNumberReader) throws IOException, ParseFormatException {
        String string = lineNumberReader.readLine();
        if (string == null) {
            throw new ParseFormatException("premature end of file: <p cnf ...> expected  on line " + lineNumberReader.getLineNumber());
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (!(stringTokenizer.hasMoreTokens() && stringTokenizer.nextToken().equals("p") && stringTokenizer.hasMoreTokens() && stringTokenizer.nextToken().equals("cnf"))) {
            throw new ParseFormatException("problem line expected (p cnf ...) on line " + lineNumberReader.getLineNumber());
        }
        int n = Integer.parseInt(stringTokenizer.nextToken());
        if (!$assertionsDisabled && n <= 0) {
            throw new AssertionError();
        }
        this.solver.newVar(n);
        this.expectedNbOfClauses = Integer.parseInt(stringTokenizer.nextToken());
        if (!$assertionsDisabled && this.expectedNbOfClauses <= 0) {
            throw new AssertionError();
        }
    }

    protected void readClauses(LineNumberReader lineNumberReader) throws IOException, ParseFormatException, ContradictionException {
        int n = 0;
        VecInt vecInt = new VecInt();
        block0: while (true) {
            String string;
            if ((string = lineNumberReader.readLine()) == null) {
                if (vecInt.size() <= 0) break;
                this.solver.addClause(vecInt);
                ++n;
                break;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (true) {
                if (!stringTokenizer.hasMoreTokens()) continue block0;
                int n2 = Integer.parseInt(stringTokenizer.nextToken());
                if (n2 != 0) {
                    vecInt.push(n2);
                    continue;
                }
                this.solver.addClause(vecInt);
                vecInt.clear();
                ++n;
            }
            break;
        }
        if (this.expectedNbOfClauses != n) {
            throw new ParseFormatException("wrong nbclauses parameter. Found " + n + ", " + this.expectedNbOfClauses + " expected");
        }
    }

    protected void readConstrs(LineNumberReader lineNumberReader) throws IOException, ParseFormatException, ContradictionException {
        int n = 0;
        VecInt vecInt = new VecInt();
        block0: while (true) {
            String string;
            if ((string = lineNumberReader.readLine()) == null) {
                if (vecInt.size() <= 0) break;
                this.solver.addClause(vecInt);
                ++n;
                break;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (true) {
                if (!stringTokenizer.hasMoreTokens()) continue block0;
                String string2 = stringTokenizer.nextToken();
                if (string2.equals("<=") || string2.equals(">=")) {
                    this.readCardinalityConstr(string2, stringTokenizer, vecInt);
                    vecInt.clear();
                    ++n;
                    continue;
                }
                int n2 = Integer.parseInt(string2);
                if (n2 != 0) {
                    vecInt.push(n2);
                    continue;
                }
                this.solver.addClause(vecInt);
                vecInt.clear();
                ++n;
            }
            break;
        }
        if (this.expectedNbOfClauses != n) {
            throw new ParseFormatException("wrong nbclauses parameter. Found " + n + ", " + this.expectedNbOfClauses + " expected");
        }
    }

    private void readCardinalityConstr(String string, StringTokenizer stringTokenizer, VecInt vecInt) throws ContradictionException, ParseFormatException {
        int n = Integer.parseInt(stringTokenizer.nextToken());
        int n2 = Integer.parseInt(stringTokenizer.nextToken());
        if (n2 == 0) {
            if (string.equals("<=")) {
                this.solver.addAtMost(vecInt, n);
            } else if (string.equals(">=")) {
                this.solver.addAtLeast(vecInt, n);
            }
        } else {
            throw new ParseFormatException();
        }
    }

    public void parseInstance(String string) throws FileNotFoundException, ParseFormatException, IOException, ContradictionException {
        if (string.endsWith(".gz")) {
            this.parseInstance(new LineNumberReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(string)))));
        } else {
            this.parseInstance(new LineNumberReader(new FileReader(string)));
        }
    }

    public void parseInstance(LineNumberReader lineNumberReader) throws ParseFormatException, ContradictionException {
        this.solver.reset();
        try {
            this.skipComments(lineNumberReader);
            this.readProblemLine(lineNumberReader);
            this.readConstrs(lineNumberReader);
        }
        catch (IOException iOException) {
            throw new ParseFormatException(iOException);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseFormatException("integer value expected on line " + lineNumberReader.getLineNumber(), numberFormatException);
        }
    }

    public String decode(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nArray.length; ++i) {
            stringBuffer.append(nArray[i]);
            stringBuffer.append(" ");
        }
        stringBuffer.append("0");
        return stringBuffer.toString();
    }

    static {
        $assertionsDisabled = !DimacsReader.class.desiredAssertionStatus();
    }
}

