/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.reader;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.reader.Reader;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.Vec;
import org.sat4j.specs.VecInt;

public class GoodOPBReader
implements Reader,
Serializable {
    private static final String COMMENT_SYMBOL = "*";
    private ISolver solver;
    private final Map map = new HashMap();
    private final Vec decode = new Vec();
    static final /* synthetic */ boolean $assertionsDisabled;

    public GoodOPBReader(ISolver iSolver) {
        this.solver = iSolver;
    }

    public void parseInstance(String string) throws FileNotFoundException, ParseFormatException, IOException, ContradictionException {
        if (string.endsWith(".gz")) {
            this.parseInstance(new LineNumberReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(string)))));
        } else {
            this.parseInstance(new LineNumberReader(new FileReader(string)));
        }
    }

    public void parseInstance(LineNumberReader lineNumberReader) throws ParseFormatException, ContradictionException, IOException {
        String string;
        this.solver.reset();
        while ((string = lineNumberReader.readLine()) != null) {
            if ((string = string.trim()).endsWith(";")) {
                string = string.substring(0, string.length() - 1);
            }
            this.parseLine(string);
        }
    }

    void parseLine(String string) throws ContradictionException {
        if (string.startsWith(COMMENT_SYMBOL)) {
            return;
        }
        if (string.startsWith("p")) {
            return;
        }
        if (string.startsWith("min:") || string.startsWith("min :")) {
            return;
        }
        if (string.startsWith("max:") || string.startsWith("max :")) {
            return;
        }
        int n = string.indexOf(":");
        if (n != -1) {
            string = string.substring(n + 1);
        }
        VecInt vecInt = new VecInt();
        VecInt vecInt2 = new VecInt();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            int n2;
            String string2 = stringTokenizer.nextToken();
            if (string2.equals(">=") || string2.equals("<=") || string2.equals("=")) {
                if (!$assertionsDisabled && !stringTokenizer.hasMoreTokens()) {
                    throw new AssertionError();
                }
                n2 = Integer.parseInt(stringTokenizer.nextToken());
                if (string2.equals(">=") || string2.equals("=")) {
                    this.solver.addPseudoBoolean(vecInt, vecInt2, true, n2);
                }
                if (!string2.equals("<=") && !string2.equals("=")) continue;
                this.solver.addPseudoBoolean(vecInt, vecInt2, false, n2);
                continue;
            }
            if (string2.equals("+")) {
                if (!$assertionsDisabled && !stringTokenizer.hasMoreTokens()) {
                    throw new AssertionError();
                }
                string2 = stringTokenizer.nextToken();
            } else if (string2.equals("-")) {
                if (!$assertionsDisabled && !stringTokenizer.hasMoreTokens()) {
                    throw new AssertionError();
                }
                string2 = string2 + stringTokenizer.nextToken();
            }
            try {
                if (string2.startsWith("+")) {
                    string2 = string2.substring(1);
                }
                n2 = Integer.parseInt(string2);
                if (!$assertionsDisabled && !stringTokenizer.hasMoreTokens()) {
                    throw new AssertionError();
                }
                string2 = stringTokenizer.nextToken();
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 1;
            }
            if (string2.equals("+") || string2.equals("-") || string2.equals("~")) {
                if (!$assertionsDisabled && !stringTokenizer.hasMoreTokens()) {
                    throw new AssertionError();
                }
                string2 = string2 + stringTokenizer.nextToken();
            }
            boolean bl = false;
            if (string2.startsWith("+")) {
                string2 = string2.substring(1);
            } else if (string2.startsWith("-")) {
                string2 = string2.substring(1);
                if (!$assertionsDisabled && n2 != 1) {
                    throw new AssertionError();
                }
                n2 = -1;
            } else if (string2.startsWith("~")) {
                string2 = string2.substring(1);
                bl = true;
            }
            Integer n3 = (Integer)this.map.get(string2);
            if (n3 == null) {
                n3 = new Integer(this.solver.newVar());
                this.map.put(string2, n3);
                this.decode.push(string2);
                if (!$assertionsDisabled && this.decode.size() != n3.intValue()) {
                    throw new AssertionError();
                }
            }
            vecInt2.push(n2);
            int n4 = (bl ? -1 : 1) * n3;
            vecInt.push(n4);
            if (!$assertionsDisabled && vecInt2.size() != vecInt.size()) {
                throw new AssertionError();
            }
        }
    }

    public String decode(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] < 0) {
                stringBuffer.append("-");
                stringBuffer.append(this.decode.get(-nArray[i] - 1));
            } else {
                stringBuffer.append(this.decode.get(nArray[i] - 1));
            }
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    static {
        $assertionsDisabled = !GoodOPBReader.class.desiredAssertionStatus();
    }
}

