/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.reader;

import java.io.IOException;
import java.io.LineNumberReader;
import org.sat4j.reader.OPBReader;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.VecInt;

public class OPBCardReader
extends OPBReader {
    private static final long serialVersionUID = 1L;
    private static final int MORETHAN = 1;
    private static final int LESSTHAN = 2;
    private static final int EQUALSTO = 3;
    static final /* synthetic */ boolean $assertionsDisabled;

    public OPBCardReader(ISolver iSolver) {
        super(iSolver);
    }

    private void addConst(int n, VecInt vecInt, int n2) throws ContradictionException {
        if ((n & 1) != 0) {
            this.solver.addAtLeast(vecInt, n2);
        }
        if ((n & 2) != 0) {
            this.solver.addAtMost(vecInt, n2);
        }
    }

    protected void readContrs(LineNumberReader lineNumberReader) throws IOException, ParseFormatException, ContradictionException {
        while (lineNumberReader.ready()) {
            int n;
            int n2;
            String[] stringArray;
            String string = lineNumberReader.readLine();
            if (string.trim().length() == 0) continue;
            int n3 = string.indexOf(":") + 1;
            int n4 = string.indexOf(";");
            if (n3 == -1 || n4 == -1) {
                throw new ParseFormatException(string);
            }
            string = string.substring(n3, n4).trim();
            VecInt vecInt = new VecInt();
            VecInt vecInt2 = new VecInt();
            if (string.indexOf(">=") != -1) {
                stringArray = string.split(">=");
                n2 = Integer.valueOf(stringArray[1].trim());
                n = 1;
            } else if (string.indexOf(">") != -1) {
                stringArray = string.split(">");
                n2 = Integer.valueOf(stringArray[1].trim()) + 1;
                n = 1;
            } else if (string.indexOf("<=") != -1) {
                stringArray = string.split("<=");
                n2 = Integer.valueOf(stringArray[1].trim());
                n = 2;
            } else if (string.indexOf("<") != -1) {
                stringArray = string.split("<");
                n2 = Integer.valueOf(stringArray[1].trim()) - 1;
                n = 2;
            } else if (string.indexOf("=") != -1) {
                stringArray = string.split("=");
                n2 = Integer.valueOf(stringArray[1].trim());
                n = 3;
            } else {
                System.out.println(lineNumberReader.getLineNumber() + string);
                throw new ParseFormatException("In\ufffdgalit\ufffd non reconnue");
            }
            this.storeLeftSide(stringArray[0], vecInt, vecInt2);
            if (!$assertionsDisabled && vecInt.size() != vecInt2.size()) {
                throw new AssertionError();
            }
            this.addConst(n, vecInt, n2);
        }
    }

    static {
        $assertionsDisabled = !OPBCardReader.class.desiredAssertionStatus();
    }
}

