/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.reader;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Serializable;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.VecInt;

public class OPBReader
implements Serializable {
    private static final int MORETHAN = 1;
    private static final int LESSTHAN = 2;
    private static final int EQUALSTO = 3;
    private final HashMap map = new HashMap();
    protected final ISolver solver;
    static final /* synthetic */ boolean $assertionsDisabled;

    public OPBReader(ISolver iSolver) {
        this.solver = iSolver;
    }

    public void parseInstance(String string) throws FileNotFoundException, ParseFormatException, IOException, ContradictionException {
        if (string.endsWith(".gz")) {
            this.parseInstance(new LineNumberReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(string)))));
        } else {
            this.parseInstance(new LineNumberReader(new FileReader(string)));
        }
    }

    public void parseInstance(LineNumberReader lineNumberReader) throws ParseFormatException, ContradictionException {
        this.solver.reset();
        try {
            this.map.clear();
            this.skipComments(lineNumberReader);
            this.readContrs(lineNumberReader);
        }
        catch (IOException iOException) {
            throw new ParseFormatException(iOException);
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("integer value expected on line " + lineNumberReader.getLineNumber());
            throw new ParseFormatException("integer value expected on line " + lineNumberReader.getLineNumber(), numberFormatException);
        }
    }

    protected void readContrs(LineNumberReader lineNumberReader) throws IOException, ParseFormatException, ContradictionException {
        while (lineNumberReader.ready()) {
            int n;
            int n2;
            String[] stringArray;
            String string = lineNumberReader.readLine();
            if (string.trim().length() == 0) continue;
            int n3 = string.indexOf(":") + 1;
            int n4 = string.indexOf(";");
            if (n3 == -1 || n4 == -1) {
                throw new ParseFormatException(string);
            }
            string = string.substring(n3, n4).trim();
            VecInt vecInt = new VecInt();
            VecInt vecInt2 = new VecInt();
            if (string.indexOf(">=") != -1) {
                stringArray = string.split(">=");
                n2 = Integer.valueOf(stringArray[1].trim());
                n = 1;
            } else if (string.indexOf(">") != -1) {
                stringArray = string.split(">");
                n2 = Integer.valueOf(stringArray[1].trim()) + 1;
                n = 1;
            } else if (string.indexOf("<=") != -1) {
                stringArray = string.split("<=");
                n2 = Integer.valueOf(stringArray[1].trim());
                n = 2;
            } else if (string.indexOf("<") != -1) {
                stringArray = string.split("<");
                n2 = Integer.valueOf(stringArray[1].trim()) - 1;
                n = 2;
            } else if (string.indexOf("=") != -1) {
                stringArray = string.split("=");
                n2 = Integer.valueOf(stringArray[1].trim());
                n = 3;
            } else {
                System.out.println(lineNumberReader.getLineNumber() + string);
                throw new ParseFormatException("In\ufffdgalit\ufffd non reconnue");
            }
            this.storeLeftSide(stringArray[0], vecInt, vecInt2);
            if (!$assertionsDisabled && vecInt.size() != vecInt2.size()) {
                throw new AssertionError();
            }
            this.addConst(n, vecInt, vecInt2, n2);
        }
    }

    private void addConst(int n, VecInt vecInt, VecInt vecInt2, int n2) throws ContradictionException {
        if ((n & 1) != 0) {
            this.solver.addPseudoBoolean(vecInt, vecInt2, true, n2);
        }
        if ((n & 2) != 0) {
            this.solver.addPseudoBoolean(vecInt, vecInt2, false, n2);
        }
    }

    protected void skipComments(LineNumberReader lineNumberReader) throws IOException {
        String string;
        do {
            string = lineNumberReader.readLine();
            if (!$assertionsDisabled && string == null) {
                throw new AssertionError();
            }
        } while (!string.startsWith("min:") && !string.startsWith("max:"));
    }

    protected void storeLeftSide(String string, VecInt vecInt, VecInt vecInt2) {
        if (!$assertionsDisabled && vecInt.size() != vecInt2.size()) {
            throw new AssertionError();
        }
        Pattern pattern = Pattern.compile("([+-][0-9]*\\s*)|(\\w+\\s*)");
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            String string2 = matcher.group();
            if ((string2 = string2.replace('+', ' ').trim()).length() == 0 || string2.equals("-")) {
                string2 = string2 + "1";
            }
            int n = Integer.parseInt(string2);
            vecInt2.push(n);
            matcher.find();
            String string3 = matcher.group();
            if (!this.map.containsKey(string3)) {
                int n2 = this.solver.newVar();
                if (!$assertionsDisabled && n2 != this.map.size() + 1) {
                    throw new AssertionError();
                }
                this.map.put(string3, new Integer(n2));
            }
            vecInt.push((Integer)this.map.get(string3));
        }
        if (!$assertionsDisabled && vecInt.size() != vecInt2.size()) {
            throw new AssertionError();
        }
    }

    static {
        $assertionsDisabled = !OPBReader.class.desiredAssertionStatus();
    }
}

