/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.specs;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Random;

public class Vec
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int RANDOM_SEED = 91648253;
    private int nbelem;
    private Object[] myarray;
    private static Random rand;
    public static final Comparator DEFAULT_COMPARATOR;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Vec() {
        this.myarray = new Object[5];
    }

    public Vec(int n, Object object) {
        this.myarray = new Object[n];
        for (int i = 0; i < n; ++i) {
            this.myarray[i] = object;
        }
        this.nbelem = n;
    }

    public int size() {
        return this.nbelem;
    }

    public void shrink(int n) {
        if (!$assertionsDisabled && n > this.size()) {
            throw new AssertionError();
        }
        while (n-- > 0) {
            this.myarray[--this.nbelem] = null;
        }
    }

    public void shrinkTo(int n) {
        if (!$assertionsDisabled && n > this.size()) {
            throw new AssertionError();
        }
        for (int i = this.nbelem; i > n; --i) {
            this.myarray[i - 1] = null;
        }
        this.nbelem = n;
        if (!$assertionsDisabled && this.size() != n) {
            throw new AssertionError();
        }
    }

    public void pop() {
        if (!$assertionsDisabled && this.size() <= 0) {
            throw new AssertionError();
        }
        this.myarray[--this.nbelem] = null;
    }

    public void growTo(int n, Object object) {
        if (!$assertionsDisabled && n < this.size()) {
            throw new AssertionError();
        }
        this.ensure(n);
        for (int i = this.nbelem; i < n; ++i) {
            this.myarray[i] = object;
        }
        this.nbelem = n;
    }

    public void ensure(int n) {
        if (n >= this.myarray.length) {
            Object[] objectArray = new Object[Math.max(n, this.nbelem * 2)];
            System.arraycopy(this.myarray, 0, objectArray, 0, this.nbelem);
            this.myarray = objectArray;
        }
    }

    public void push(Object object) {
        this.ensure(this.nbelem + 1);
        this.myarray[this.nbelem++] = object;
    }

    public void insertFirst(Object object) {
        if (this.nbelem > 0) {
            this.push(this.myarray[0]);
            this.myarray[0] = object;
            return;
        }
        this.push(object);
    }

    public void insertFirstWithShifting(Object object) {
        if (this.nbelem > 0) {
            this.ensure(this.nbelem + 1);
            for (int i = this.nbelem; i > 0; --i) {
                this.myarray[i] = this.myarray[i - 1];
            }
            this.myarray[0] = object;
            ++this.nbelem;
            return;
        }
        this.push(object);
    }

    public void clear() {
        while (this.nbelem > 0) {
            this.myarray[--this.nbelem] = null;
        }
    }

    public Object last() {
        if (!$assertionsDisabled && this.size() == 0) {
            throw new AssertionError();
        }
        return this.myarray[this.nbelem - 1];
    }

    public Object get(int n) {
        return this.myarray[n];
    }

    public void set(int n, Object object) {
        this.myarray[n] = object;
    }

    public void remove(Object object) {
        if (!$assertionsDisabled && this.size() <= 0) {
            throw new AssertionError();
        }
        int n = 0;
        while (this.myarray[n] != object) {
            if (!$assertionsDisabled && n >= this.size()) {
                throw new AssertionError();
            }
            ++n;
        }
        while (n < this.size() - 1) {
            this.myarray[n] = this.myarray[n + 1];
            ++n;
        }
        this.pop();
    }

    public Object delete(int n) {
        if (!$assertionsDisabled && n < 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && n >= this.nbelem) {
            throw new AssertionError();
        }
        Object object = this.myarray[n];
        this.myarray[n] = this.myarray[--this.nbelem];
        this.myarray[this.nbelem] = null;
        return object;
    }

    public void copyTo(Vec vec) {
        int n = this.nbelem + vec.nbelem;
        vec.ensure(n);
        for (int i = 0; i < this.nbelem; ++i) {
            vec.myarray[i + vec.nbelem] = this.myarray[i];
        }
        vec.nbelem = n;
    }

    public void moveTo(Vec vec) {
        this.copyTo(vec);
        this.clear();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.nbelem - 1; ++i) {
            stringBuffer.append(this.myarray[i]);
            stringBuffer.append(",");
        }
        if (this.nbelem > 0) {
            stringBuffer.append(this.myarray[this.nbelem - 1]);
        }
        return stringBuffer.toString();
    }

    void selectionSort(int n, int n2, Comparator comparator) {
        for (int i = n; i < n2 - 1; ++i) {
            int n3 = i;
            for (int j = i + 1; j < n2; ++j) {
                if (comparator.compare(this.myarray[j], this.myarray[n3]) >= 0) continue;
                n3 = j;
            }
            Object object = this.myarray[i];
            this.myarray[i] = this.myarray[n3];
            this.myarray[n3] = object;
        }
    }

    void sort(int n, int n2, Comparator comparator) {
        int n3 = n2 - n;
        if (n2 - n <= 15) {
            this.selectionSort(n, n2, comparator);
        } else {
            Object object = this.myarray[rand.nextInt(n3) + n];
            int n4 = n - 1;
            int n5 = n2;
            while (true) {
                if (comparator.compare(this.myarray[++n4], object) < 0) {
                    continue;
                }
                while (comparator.compare(object, this.myarray[--n5]) < 0) {
                }
                if (n4 >= n5) break;
                Object object2 = this.myarray[n4];
                this.myarray[n4] = this.myarray[n5];
                this.myarray[n5] = object2;
            }
            this.sort(n, n4, comparator);
            this.sort(n4, n2, comparator);
        }
    }

    public void sort(Comparator comparator) {
        this.sort(0, this.nbelem, comparator);
    }

    public void sort() {
        this.sort(DEFAULT_COMPARATOR);
    }

    void sortUnique(Comparator comparator) {
        if (this.nbelem == 0) {
            return;
        }
        this.sort(0, this.nbelem, comparator);
        int n = 1;
        Object object = this.myarray[0];
        for (int i = 1; i < this.nbelem; ++i) {
            if (comparator.compare(object, this.myarray[i]) >= 0) continue;
            object = this.myarray[n] = this.myarray[i];
            ++n;
        }
        this.nbelem = n;
    }

    public void sortUnique() {
        this.sortUnique(DEFAULT_COMPARATOR);
    }

    public boolean equals(Object object) {
        if (object instanceof Vec) {
            Vec vec = (Vec)object;
            if (vec.size() != this.size()) {
                return false;
            }
            for (int i = 0; i < this.size(); ++i) {
                if (vec.get(i).equals(this.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    static {
        $assertionsDisabled = !Vec.class.desiredAssertionStatus();
        rand = new Random(91648253L);
        DEFAULT_COMPARATOR = new Comparator(){

            public int compare(Object object, Object object2) {
                return ((Comparable)object).compareTo(object2);
            }
        };
    }
}

