/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.specs;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Random;

public class VecBigInt
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int RANDOM_SEED = 91648253;
    private int nbelem;
    private BigInteger[] myarray;
    private static Random rand;
    static final /* synthetic */ boolean $assertionsDisabled;

    public VecBigInt() {
        this(5);
    }

    public VecBigInt(int n) {
        this.myarray = new BigInteger[n];
    }

    public int size() {
        return this.nbelem;
    }

    public void shrink(int n) {
        if (!$assertionsDisabled && n < 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && n > this.size()) {
            throw new AssertionError();
        }
        this.nbelem -= n;
    }

    public void shrinkTo(int n) {
        if (!$assertionsDisabled && n < 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && n >= this.nbelem) {
            throw new AssertionError();
        }
        this.nbelem = n;
    }

    public void pop() {
        if (!$assertionsDisabled && this.size() == 0) {
            throw new AssertionError();
        }
        --this.nbelem;
    }

    public void ensure(int n) {
        if (n >= this.myarray.length) {
            BigInteger[] bigIntegerArray = new BigInteger[Math.max(n, this.nbelem * 2)];
            System.arraycopy(this.myarray, 0, bigIntegerArray, 0, this.nbelem);
            this.myarray = bigIntegerArray;
        }
    }

    public void push(BigInteger bigInteger) {
        this.ensure(this.nbelem + 1);
        this.myarray[this.nbelem++] = bigInteger;
    }

    public void clear() {
        this.nbelem = 0;
    }

    public BigInteger last() {
        if (!$assertionsDisabled && this.nbelem <= 0) {
            throw new AssertionError();
        }
        return this.myarray[this.nbelem - 1];
    }

    public BigInteger get(int n) {
        if (!$assertionsDisabled && n < 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && n >= this.nbelem) {
            throw new AssertionError();
        }
        return this.myarray[n];
    }

    public void set(int n, BigInteger bigInteger) {
        if (!$assertionsDisabled && n < 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && n >= this.nbelem) {
            throw new AssertionError();
        }
        this.myarray[n] = bigInteger;
    }

    public boolean contains(BigInteger bigInteger) {
        for (int i = 0; i < this.nbelem; ++i) {
            if (!this.myarray[i].equals(bigInteger)) continue;
            return true;
        }
        return false;
    }

    public void copyTo(VecBigInt vecBigInt) {
        int n = this.nbelem + vecBigInt.nbelem;
        vecBigInt.ensure(n);
        System.arraycopy(this.myarray, 0, vecBigInt.myarray, vecBigInt.nbelem, this.nbelem);
        vecBigInt.nbelem = n;
    }

    public void copyTo(int[] nArray) {
        if (!$assertionsDisabled && nArray.length < this.nbelem) {
            throw new AssertionError();
        }
        System.arraycopy(this.myarray, 0, nArray, 0, this.nbelem);
    }

    public void moveTo(VecBigInt vecBigInt) {
        int n = this.nbelem + vecBigInt.nbelem;
        vecBigInt.ensure(n);
        System.arraycopy(this.myarray, 0, vecBigInt.myarray, vecBigInt.nbelem, this.nbelem);
        vecBigInt.nbelem = n;
        this.nbelem = 0;
    }

    public void moveTo2(VecBigInt vecBigInt) {
        int n = vecBigInt.nbelem;
        BigInteger[] bigIntegerArray = vecBigInt.myarray;
        vecBigInt.myarray = this.myarray;
        vecBigInt.nbelem = this.nbelem;
        this.myarray = bigIntegerArray;
        this.nbelem = n;
        this.nbelem = 0;
    }

    public void moveTo(int[] nArray) {
        System.arraycopy(this.myarray, 0, nArray, 0, this.nbelem);
        this.nbelem = 0;
    }

    public BigInteger delete(int n) {
        if (!$assertionsDisabled && n < 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && n >= this.nbelem) {
            throw new AssertionError();
        }
        BigInteger bigInteger = this.myarray[n];
        this.myarray[n] = this.myarray[--this.nbelem];
        return bigInteger;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.nbelem - 1; ++i) {
            stringBuffer.append(this.myarray[i]);
            stringBuffer.append(",");
        }
        if (this.nbelem > 0) {
            stringBuffer.append(this.myarray[this.nbelem - 1]);
        }
        return stringBuffer.toString();
    }

    void selectionSort(int n, int n2) {
        for (int i = n; i < n2 - 1; ++i) {
            int n3 = i;
            for (int j = i + 1; j < n2; ++j) {
                if (this.myarray[j].compareTo(this.myarray[n3]) >= 0) continue;
                n3 = j;
            }
            BigInteger bigInteger = this.myarray[i];
            this.myarray[i] = this.myarray[n3];
            this.myarray[n3] = bigInteger;
        }
    }

    void sort(int n, int n2) {
        int n3 = n2 - n;
        if (n2 - n <= 15) {
            this.selectionSort(n, n2);
        } else {
            BigInteger bigInteger = this.myarray[rand.nextInt(n3) + n];
            int n4 = n - 1;
            int n5 = n2;
            while (true) {
                if (this.myarray[++n4].compareTo(bigInteger) < 0) {
                    continue;
                }
                while (bigInteger.compareTo(this.myarray[--n5]) < 0) {
                }
                if (n4 >= n5) break;
                BigInteger bigInteger2 = this.myarray[n4];
                this.myarray[n4] = this.myarray[n5];
                this.myarray[n5] = bigInteger2;
            }
            this.sort(n, n4);
            this.sort(n4, n2);
        }
    }

    public void sort() {
        this.sort(0, this.nbelem);
    }

    public void sortUnique() {
        if (this.nbelem == 0) {
            return;
        }
        this.sort(0, this.nbelem);
        int n = 1;
        BigInteger bigInteger = this.myarray[0];
        for (int i = 1; i < this.nbelem; ++i) {
            if (bigInteger.compareTo(this.myarray[i]) >= 0) continue;
            bigInteger = this.myarray[n] = this.myarray[i];
            ++n;
        }
        this.nbelem = n;
    }

    static {
        $assertionsDisabled = !VecBigInt.class.desiredAssertionStatus();
        rand = new Random(91648253L);
    }
}

