/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.specs;

import java.io.Serializable;
import java.util.Random;

public class VecInt
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int RANDOM_SEED = 91648253;
    private int nbelem;
    private int[] myarray;
    private static Random rand;
    static final /* synthetic */ boolean $assertionsDisabled;

    public VecInt() {
        this(5);
    }

    public VecInt(int n) {
        this.myarray = new int[n];
    }

    public VecInt(int n, int n2) {
        this.myarray = new int[n];
        for (int i = 0; i < n; ++i) {
            this.myarray[i] = n2;
        }
        this.nbelem = n;
    }

    public int size() {
        return this.nbelem;
    }

    public void shrink(int n) {
        if (!$assertionsDisabled && n < 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && n > this.size()) {
            throw new AssertionError();
        }
        this.nbelem -= n;
    }

    public void shrinkTo(int n) {
        if (!$assertionsDisabled && n < 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && n >= this.nbelem) {
            throw new AssertionError();
        }
        this.nbelem = n;
    }

    public VecInt pop() {
        if (!$assertionsDisabled && this.size() == 0) {
            throw new AssertionError();
        }
        --this.nbelem;
        return this;
    }

    public void growTo(int n, int n2) {
        if (!$assertionsDisabled && n <= this.size()) {
            throw new AssertionError();
        }
        this.ensure(n);
        while (--n >= 0) {
            this.myarray[this.nbelem++] = n2;
        }
    }

    public void ensure(int n) {
        if (n >= this.myarray.length) {
            int[] nArray = new int[Math.max(n, this.nbelem * 2)];
            System.arraycopy(this.myarray, 0, nArray, 0, this.nbelem);
            this.myarray = nArray;
        }
    }

    public VecInt push(int n) {
        this.ensure(this.nbelem + 1);
        this.myarray[this.nbelem++] = n;
        return this;
    }

    public void clear() {
        this.nbelem = 0;
    }

    public int last() {
        if (!$assertionsDisabled && this.nbelem <= 0) {
            throw new AssertionError();
        }
        return this.myarray[this.nbelem - 1];
    }

    public int get(int n) {
        if (!$assertionsDisabled && n < 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && n >= this.nbelem) {
            throw new AssertionError();
        }
        return this.myarray[n];
    }

    public void set(int n, int n2) {
        if (!$assertionsDisabled && n < 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && n >= this.nbelem) {
            throw new AssertionError();
        }
        this.myarray[n] = n2;
    }

    public boolean contains(int n) {
        for (int i = 0; i < this.nbelem; ++i) {
            if (this.myarray[i] != n) continue;
            return true;
        }
        return false;
    }

    public void copyTo(VecInt vecInt) {
        int n = this.nbelem + vecInt.nbelem;
        vecInt.ensure(n);
        System.arraycopy(this.myarray, 0, vecInt.myarray, vecInt.nbelem, this.nbelem);
        vecInt.nbelem = n;
    }

    public void copyTo(int[] nArray) {
        if (!$assertionsDisabled && nArray.length < this.nbelem) {
            throw new AssertionError();
        }
        System.arraycopy(this.myarray, 0, nArray, 0, this.nbelem);
    }

    public void moveTo(VecInt vecInt) {
        int n = this.nbelem + vecInt.nbelem;
        vecInt.ensure(n);
        System.arraycopy(this.myarray, 0, vecInt.myarray, vecInt.nbelem, this.nbelem);
        vecInt.nbelem = n;
        this.nbelem = 0;
    }

    public void moveTo2(VecInt vecInt) {
        int n = vecInt.nbelem;
        int[] nArray = vecInt.myarray;
        vecInt.myarray = this.myarray;
        vecInt.nbelem = this.nbelem;
        this.myarray = nArray;
        this.nbelem = n;
        this.nbelem = 0;
    }

    public void moveTo(int[] nArray) {
        System.arraycopy(this.myarray, 0, nArray, 0, this.nbelem);
        this.nbelem = 0;
    }

    public void insertFirst(int n) {
        if (this.nbelem > 0) {
            this.push(this.myarray[0]);
            this.myarray[0] = n;
            return;
        }
        this.push(n);
    }

    public void remove(int n) {
        if (!$assertionsDisabled && this.size() <= 0) {
            throw new AssertionError();
        }
        int n2 = 0;
        while (this.myarray[n2] != n) {
            if (!$assertionsDisabled && n2 >= this.size()) {
                throw new AssertionError();
            }
            ++n2;
        }
        while (n2 < this.size() - 1) {
            this.myarray[n2] = this.myarray[n2 + 1];
            ++n2;
        }
        this.pop();
    }

    public int delete(int n) {
        if (!$assertionsDisabled && n < 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && n >= this.nbelem) {
            throw new AssertionError();
        }
        int n2 = this.myarray[n];
        this.myarray[n] = this.myarray[--this.nbelem];
        return n2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.nbelem - 1; ++i) {
            stringBuffer.append(this.myarray[i]);
            stringBuffer.append(",");
        }
        if (this.nbelem > 0) {
            stringBuffer.append(this.myarray[this.nbelem - 1]);
        }
        return stringBuffer.toString();
    }

    void selectionSort(int n, int n2) {
        for (int i = n; i < n2 - 1; ++i) {
            int n3 = i;
            for (int j = i + 1; j < n2; ++j) {
                if (this.myarray[j] >= this.myarray[n3]) continue;
                n3 = j;
            }
            int n4 = this.myarray[i];
            this.myarray[i] = this.myarray[n3];
            this.myarray[n3] = n4;
        }
    }

    void sort(int n, int n2) {
        int n3 = n2 - n;
        if (n2 - n <= 15) {
            this.selectionSort(n, n2);
        } else {
            int n4 = this.myarray[rand.nextInt(n3) + n];
            int n5 = n - 1;
            int n6 = n2;
            while (true) {
                if (this.myarray[++n5] < n4) {
                    continue;
                }
                while (n4 < this.myarray[--n6]) {
                }
                if (n5 >= n6) break;
                int n7 = this.myarray[n5];
                this.myarray[n5] = this.myarray[n6];
                this.myarray[n6] = n7;
            }
            this.sort(n, n5);
            this.sort(n5, n2);
        }
    }

    public void sort() {
        this.sort(0, this.nbelem);
    }

    public void sortUnique() {
        if (this.nbelem == 0) {
            return;
        }
        this.sort(0, this.nbelem);
        int n = 1;
        int n2 = this.myarray[0];
        for (int i = 1; i < this.nbelem; ++i) {
            if (n2 >= this.myarray[i]) continue;
            n2 = this.myarray[n] = this.myarray[i];
            ++n;
        }
        this.nbelem = n;
    }

    public boolean equals(Object object) {
        if (object instanceof VecInt) {
            VecInt vecInt = (VecInt)object;
            if (vecInt.size() != this.size()) {
                return false;
            }
            for (int i = 0; i < this.size(); ++i) {
                if (vecInt.get(i) == this.get(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    static {
        $assertionsDisabled = !VecInt.class.desiredAssertionStatus();
        rand = new Random(91648253L);
    }
}

