/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.URL;
import java.util.Properties;
import org.sat4j.ExitCode;
import org.sat4j.core.ASolverFactory;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.reader.Reader;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IProblem;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.TimeoutException;

public abstract class AbstractLauncher
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SOLUTION_PREFIX = "v ";
    public static final String ANSWER_PREFIX = "s ";
    public static final String COMMENT_PREFIX = "c ";
    private long beginTime;
    private ExitCode exitCode = ExitCode.UNKNOWN;
    protected Reader reader;
    private transient PrintWriter out = new PrintWriter(System.out, true);
    protected transient Thread shutdownHook = new Thread(){

        @Override
        public void run() {
            AbstractLauncher.this.displayResult();
        }
    };
    protected ISolver solver;
    private boolean silent = false;

    protected AbstractLauncher() {
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
    }

    protected void displayResult() {
        if (this.solver != null) {
            double wallclocktime = (double)(System.currentTimeMillis() - this.beginTime) / 1000.0;
            this.solver.printStat(this.out, COMMENT_PREFIX);
            this.out.println(ANSWER_PREFIX + this.exitCode);
            if (this.exitCode == ExitCode.SATISFIABLE) {
                int[] model = this.solver.model();
                this.out.print(SOLUTION_PREFIX);
                this.reader.decode(model, this.out);
                this.out.println();
            }
            this.log("Total wall clock time (in seconds) : " + wallclocktime);
        }
    }

    public abstract void usage();

    protected final void displayHeader() {
        String[] infoskeys;
        block17: {
            this.displayLicense();
            URL url = AbstractLauncher.class.getResource("/sat4j.version");
            if (url == null) {
                this.log("no version file found!!!");
            } else {
                BufferedReader in = null;
                try {
                    try {
                        in = new BufferedReader(new InputStreamReader(url.openStream()));
                        this.log("version " + in.readLine());
                    }
                    catch (IOException e) {
                        this.log("c ERROR: " + e.getMessage());
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException e2) {
                                this.log("c ERROR: " + e2.getMessage());
                            }
                        }
                        break block17;
                    }
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e) {
                            this.log("c ERROR: " + e.getMessage());
                        }
                    }
                    throw throwable;
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        this.log("c ERROR: " + e.getMessage());
                    }
                }
            }
        }
        Properties prop = System.getProperties();
        String[] stringArray = infoskeys = new String[]{"sun.arch.data.model", "java.version", "os.name", "os.version", "os.arch"};
        int n = infoskeys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            this.log(String.valueOf(key) + "\t" + prop.getProperty(key));
            ++n2;
        }
        Runtime runtime = Runtime.getRuntime();
        this.log("Free memory " + runtime.freeMemory());
        this.log("Max memory " + runtime.maxMemory());
        this.log("Total memory " + runtime.totalMemory());
        this.log("Number of processors " + runtime.availableProcessors());
    }

    public void displayLicense() {
        this.log("SAT4J: a SATisfiability library for Java (c) 2004-2008 Daniel Le Berre");
        this.log("This is free software under the dual EPL/GNU LGPL licenses.");
        this.log("See www.sat4j.org for details.");
    }

    protected IProblem readProblem(String problemname) throws FileNotFoundException, ParseFormatException, IOException, ContradictionException {
        this.log("solving " + problemname);
        this.log("reading problem ... ");
        this.reader = this.createReader(this.solver, problemname);
        IProblem problem = this.reader.parseInstance(problemname);
        this.log("... done. Wall clock time " + (double)(System.currentTimeMillis() - this.beginTime) / 1000.0 + "s.");
        this.log("#vars     " + problem.nVars());
        this.log("#constraints  " + problem.nConstraints());
        problem.printInfos(this.out, COMMENT_PREFIX);
        return problem;
    }

    protected abstract Reader createReader(ISolver var1, String var2);

    public void run(String[] args) {
        try {
            this.displayHeader();
            this.solver = this.configureSolver(args);
            if (this.solver == null) {
                return;
            }
            String instanceName = this.getInstanceName(args);
            this.beginTime = System.currentTimeMillis();
            IProblem problem = this.readProblem(instanceName);
            try {
                this.solve(problem);
            }
            catch (TimeoutException e) {
                this.log("timeout");
            }
        }
        catch (FileNotFoundException e) {
            this.log("FATAL");
            e.printStackTrace();
        }
        catch (IOException e) {
            this.log("FATAL");
            e.printStackTrace();
        }
        catch (ContradictionException e) {
            this.exitCode = ExitCode.UNSATISFIABLE;
            this.log("(trivial inconsistency)");
        }
        catch (ParseFormatException e) {
            this.log("FATAL");
            e.printStackTrace();
        }
    }

    protected abstract String getInstanceName(String[] var1);

    protected abstract ISolver configureSolver(String[] var1);

    public void log(String message) {
        if (!this.silent) {
            this.out.println(COMMENT_PREFIX + message);
        }
    }

    protected void solve(IProblem problem) throws TimeoutException {
        this.exitCode = problem.isSatisfiable() ? ExitCode.SATISFIABLE : ExitCode.UNSATISFIABLE;
    }

    public final void setExitCode(ExitCode exitCode) {
        this.exitCode = exitCode;
    }

    public final ExitCode getExitCode() {
        return this.exitCode;
    }

    public final long getBeginTime() {
        return this.beginTime;
    }

    public final Reader getReader() {
        return this.reader;
    }

    public void setLogWriter(PrintWriter out) {
        this.out = out;
    }

    public PrintWriter getLogWriter() {
        return this.out;
    }

    protected void setSilent(boolean b) {
        this.silent = b;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.out = new PrintWriter(System.out, true);
        this.shutdownHook = new Thread(){

            @Override
            public void run() {
                AbstractLauncher.this.displayResult();
            }
        };
    }

    protected <T extends ISolver> void showAvailableSolvers(ASolverFactory<T> afactory) {
        if (afactory != null) {
            this.log("Available solvers: ");
            String[] names = afactory.solverNames();
            int i = 0;
            while (i < names.length) {
                this.log(names[i]);
                ++i;
            }
        }
    }
}

