/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j;

import org.sat4j.AbstractLauncher;
import org.sat4j.core.ASolverFactory;
import org.sat4j.minisat.SolverFactory;
import org.sat4j.reader.InstanceReader;
import org.sat4j.reader.Reader;
import org.sat4j.specs.ISolver;

public class BasicLauncher<T extends ISolver>
extends AbstractLauncher {
    private static final long serialVersionUID = 1L;
    private final ASolverFactory<T> factory;

    public BasicLauncher(ASolverFactory<T> factory) {
        this.factory = factory;
    }

    public static void main(String[] args) {
        BasicLauncher<ISolver> lanceur = new BasicLauncher<ISolver>(SolverFactory.instance());
        if (args.length != 1) {
            lanceur.usage();
            return;
        }
        lanceur.run(args);
        System.exit(lanceur.getExitCode().value());
    }

    @Override
    protected ISolver configureSolver(String[] args) {
        T asolver = this.factory.defaultSolver();
        asolver.setTimeout(Integer.MAX_VALUE);
        asolver.setDBSimplificationAllowed(true);
        this.log(asolver.toString("c "));
        return asolver;
    }

    @Override
    protected Reader createReader(ISolver solver, String problemname) {
        return new InstanceReader(solver);
    }

    @Override
    public void usage() {
        this.log("java -jar org.sat4j.core.jar <cnffile>");
    }

    @Override
    protected String getInstanceName(String[] args) {
        assert (args.length == 1);
        return args[0];
    }
}

