/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.core;

import java.util.NoSuchElementException;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.IteratorInt;

public class VecInt
implements IVecInt {
    private static final long serialVersionUID = 1L;
    public static final IVecInt EMPTY = new VecInt(){
        private static final long serialVersionUID = 1L;

        @Override
        public int size() {
            return 0;
        }

        @Override
        public void shrink(int nofelems) {
        }

        @Override
        public void shrinkTo(int newsize) {
        }

        @Override
        public IVecInt pop() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void growTo(int newsize, int pad) {
        }

        @Override
        public void ensure(int nsize) {
        }

        @Override
        public IVecInt push(int elem) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void unsafePush(int elem) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
        }

        @Override
        public int last() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int get(int i) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(int i, int o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(int e) {
            return false;
        }

        @Override
        public void copyTo(IVecInt copy) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void copyTo(int[] is) {
        }

        @Override
        public void moveTo(IVecInt dest) {
        }

        @Override
        public void moveTo2(IVecInt dest) {
        }

        @Override
        public void moveTo(int[] dest) {
        }

        @Override
        public void insertFirst(int elem) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void remove(int elem) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int delete(int i) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void sort() {
        }

        @Override
        public void sortUnique() {
        }
    };
    private int nbelem;
    private int[] myarray;

    public VecInt() {
        this(5);
    }

    public VecInt(int size) {
        this.myarray = new int[size];
    }

    public VecInt(int[] lits) {
        this.myarray = lits;
        this.nbelem = lits.length;
    }

    public VecInt(int size, int pad) {
        this.myarray = new int[size];
        int i = 0;
        while (i < size) {
            this.myarray[i] = pad;
            ++i;
        }
        this.nbelem = size;
    }

    @Override
    public int size() {
        return this.nbelem;
    }

    @Override
    public void shrink(int nofelems) {
        this.nbelem -= nofelems;
    }

    @Override
    public void shrinkTo(int newsize) {
        this.nbelem = newsize;
    }

    @Override
    public IVecInt pop() {
        --this.nbelem;
        return this;
    }

    @Override
    public void growTo(int newsize, int pad) {
        this.ensure(newsize);
        while (--newsize >= 0) {
            this.myarray[this.nbelem++] = pad;
        }
    }

    @Override
    public void ensure(int nsize) {
        if (nsize >= this.myarray.length) {
            int[] narray = new int[Math.max(nsize, this.nbelem * 2)];
            System.arraycopy(this.myarray, 0, narray, 0, this.nbelem);
            this.myarray = narray;
        }
    }

    @Override
    public IVecInt push(int elem) {
        this.ensure(this.nbelem + 1);
        this.myarray[this.nbelem++] = elem;
        return this;
    }

    @Override
    public void unsafePush(int elem) {
        this.myarray[this.nbelem++] = elem;
    }

    @Override
    public void clear() {
        this.nbelem = 0;
    }

    @Override
    public int last() {
        return this.myarray[this.nbelem - 1];
    }

    @Override
    public int get(int i) {
        return this.myarray[i];
    }

    @Override
    public int unsafeGet(int i) {
        return this.myarray[i];
    }

    @Override
    public void set(int i, int o) {
        assert (i >= 0 && i < this.nbelem);
        this.myarray[i] = o;
    }

    @Override
    public boolean contains(int e) {
        int[] workArray = this.myarray;
        int i = 0;
        while (i < this.nbelem) {
            if (workArray[i] == e) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public int containsAt(int e) {
        return this.containsAt(e, -1);
    }

    @Override
    public int containsAt(int e, int from) {
        int[] workArray = this.myarray;
        int i = from + 1;
        while (i < this.nbelem) {
            if (workArray[i] == e) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public void copyTo(IVecInt copy) {
        VecInt ncopy = (VecInt)copy;
        int nsize = this.nbelem + ncopy.nbelem;
        ncopy.ensure(nsize);
        System.arraycopy(this.myarray, 0, ncopy.myarray, ncopy.nbelem, this.nbelem);
        ncopy.nbelem = nsize;
    }

    @Override
    public void copyTo(int[] is) {
        System.arraycopy(this.myarray, 0, is, 0, this.nbelem);
    }

    @Override
    public void moveTo(IVecInt dest) {
        this.copyTo(dest);
        this.nbelem = 0;
    }

    @Override
    public void moveTo2(IVecInt dest) {
        VecInt ndest = (VecInt)dest;
        int s = ndest.nbelem;
        int[] tmp = ndest.myarray;
        ndest.myarray = this.myarray;
        ndest.nbelem = this.nbelem;
        this.myarray = tmp;
        this.nbelem = s;
        this.nbelem = 0;
    }

    @Override
    public void moveTo(int dest, int source) {
        this.myarray[dest] = this.myarray[source];
    }

    @Override
    public void moveTo(int[] dest) {
        System.arraycopy(this.myarray, 0, dest, 0, this.nbelem);
        this.nbelem = 0;
    }

    @Override
    public void insertFirst(int elem) {
        if (this.nbelem > 0) {
            this.push(this.myarray[0]);
            this.myarray[0] = elem;
            return;
        }
        this.push(elem);
    }

    @Override
    public void remove(int elem) {
        int j = 0;
        while (this.myarray[j] != elem) {
            assert (j < this.size());
            ++j;
        }
        System.arraycopy(this.myarray, j + 1, this.myarray, j, this.size() - j);
        this.pop();
    }

    @Override
    public int delete(int i) {
        int ith = this.myarray[i];
        this.myarray[i] = this.myarray[--this.nbelem];
        return ith;
    }

    public String toString() {
        StringBuffer stb = new StringBuffer();
        int i = 0;
        while (i < this.nbelem - 1) {
            stb.append(this.myarray[i]);
            stb.append(",");
            ++i;
        }
        if (this.nbelem > 0) {
            stb.append(this.myarray[this.nbelem - 1]);
        }
        return stb.toString();
    }

    void selectionSort(int from, int to) {
        int i = from;
        while (i < to - 1) {
            int best_i = i;
            int j = i + 1;
            while (j < to) {
                if (this.myarray[j] < this.myarray[best_i]) {
                    best_i = j;
                }
                ++j;
            }
            int tmp = this.myarray[i];
            this.myarray[i] = this.myarray[best_i];
            this.myarray[best_i] = tmp;
            ++i;
        }
    }

    void sort(int from, int to) {
        int width = to - from;
        if (width <= 15) {
            this.selectionSort(from, to);
        } else {
            int[] locarray = this.myarray;
            int pivot = locarray[width / 2 + from];
            int i = from - 1;
            int j = to;
            while (true) {
                if (locarray[++i] < pivot) {
                    continue;
                }
                while (pivot < locarray[--j]) {
                }
                if (i >= j) break;
                int tmp = locarray[i];
                locarray[i] = locarray[j];
                locarray[j] = tmp;
            }
            this.sort(from, i);
            this.sort(i, to);
        }
    }

    @Override
    public void sort() {
        this.sort(0, this.nbelem);
    }

    @Override
    public void sortUnique() {
        if (this.nbelem == 0) {
            return;
        }
        this.sort(0, this.nbelem);
        int i = 1;
        int[] locarray = this.myarray;
        int last = locarray[0];
        int j = 1;
        while (j < this.nbelem) {
            if (last < locarray[j]) {
                last = locarray[i] = locarray[j];
                ++i;
            }
            ++j;
        }
        this.nbelem = i;
    }

    public boolean equals(Object obj) {
        if (obj instanceof VecInt) {
            VecInt v = (VecInt)obj;
            if (v.nbelem != this.nbelem) {
                return false;
            }
            int i = 0;
            while (i < this.nbelem) {
                if (v.myarray[i] != this.myarray[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        long sum = 0L;
        int i = 0;
        while (i < this.nbelem) {
            sum += (long)this.myarray[i];
            ++i;
        }
        return (int)sum / this.nbelem;
    }

    public void pushAll(IVecInt vec) {
        VecInt nvec = (VecInt)vec;
        int nsize = this.nbelem + nvec.nbelem;
        this.ensure(nsize);
        System.arraycopy(nvec.myarray, 0, this.myarray, this.nbelem, nvec.nbelem);
        this.nbelem = nsize;
    }

    /*
     * Unable to fully structure code
     */
    public boolean isSubsetOf(VecInt vec) {
        i = 0;
        j = 0;
        ** GOTO lbl10
        {
            ++j;
            do {
                if (j < vec.nbelem && vec.myarray[j] < this.myarray[i]) continue block0;
                if (j == vec.nbelem || this.myarray[i] != vec.myarray[j]) {
                    return false;
                }
                ++i;
lbl10:
                // 2 sources

            } while (i < this.nbelem && j < vec.nbelem);
        }
        return true;
    }

    @Override
    public IteratorInt iterator() {
        return new IteratorInt(){
            private int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < VecInt.this.nbelem;
            }

            @Override
            public int next() {
                if (this.i == VecInt.this.nbelem) {
                    throw new NoSuchElementException();
                }
                return VecInt.this.myarray[this.i++];
            }
        };
    }

    @Override
    public boolean isEmpty() {
        return this.nbelem == 0;
    }
}

