/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.csp;

import java.util.NoSuchElementException;
import org.sat4j.csp.Domain;
import org.sat4j.specs.IteratorInt;

public class EnumeratedDomain
implements Domain {
    private final int[] values;

    public EnumeratedDomain(int[] values) {
        this.values = values;
    }

    @Override
    public int get(int i) {
        return this.values[i];
    }

    @Override
    public int size() {
        return this.values.length;
    }

    @Override
    public IteratorInt iterator() {
        return new IteratorInt(){
            private int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < EnumeratedDomain.this.values.length;
            }

            @Override
            public int next() {
                if (this.i == EnumeratedDomain.this.values.length) {
                    throw new NoSuchElementException();
                }
                return EnumeratedDomain.this.values[this.i++];
            }
        };
    }

    @Override
    public int pos(int value) {
        int i = 0;
        while (i < this.values.length) {
            if (this.values[i] == value) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

