/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.csp;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.sat4j.core.Vec;
import org.sat4j.csp.Clausifiable;
import org.sat4j.csp.Domain;
import org.sat4j.csp.Encoding;
import org.sat4j.csp.Evaluable;
import org.sat4j.csp.Var;
import org.sat4j.csp.encodings.BinarySupportEncoding;
import org.sat4j.csp.encodings.DirectEncoding;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVec;

public class Predicate
implements Clausifiable {
    private String expr;
    private Encoding encoding;
    private final IVec<String> variables = new Vec<String>();
    private static Context cx = Context.enter();
    private static Scriptable scope = cx.initStandardObjects();
    private final Map<Evaluable, Integer> valuemapping = new HashMap<Evaluable, Integer>();
    private Script myscript;

    static {
        try {
            URL url = Predicate.class.getResource("predefinedfunctions.js");
            cx.evaluateReader(scope, new InputStreamReader(url.openStream()), "predefinedfunctions.js", 1, null);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setExpression(String expr) {
        this.expr = expr.replaceAll("if\\(", "ite(");
    }

    public void addVariable(String name) {
        this.variables.push(name);
    }

    private boolean evaluate(int[] values) {
        assert (values.length == this.variables.size());
        int i = 0;
        while (i < this.variables.size()) {
            scope.put(this.variables.get(i), scope, (Object)values[i]);
            ++i;
        }
        Object result = this.myscript.exec(cx, scope);
        return Context.toBoolean(result);
    }

    @Override
    public void toClause(ISolver solver, IVec<Var> vscope, IVec<Evaluable> vars) throws ContradictionException {
        if (this.myscript == null) {
            this.myscript = cx.compileString(this.expr, "rhino.log", 1, null);
        }
        this.encoding = vscope.size() == 2 ? BinarySupportEncoding.instance() : DirectEncoding.instance();
        this.encoding.onInit(solver, vscope);
        int[] tuple = new int[vars.size()];
        this.valuemapping.clear();
        this.find(tuple, 0, vscope, vars, solver);
        this.encoding.onFinish(solver, vscope);
    }

    private void find(int[] tuple, int n, IVec<Var> scope, IVec<Evaluable> vars, ISolver solver) throws ContradictionException {
        if (this.valuemapping.size() == scope.size()) {
            int i = 0;
            while (i < tuple.length) {
                Evaluable ev = vars.get(i);
                Integer value = this.valuemapping.get(ev);
                tuple[i] = value == null ? ev.domain().get(0) : value.intValue();
                ++i;
            }
            if (this.evaluate(tuple)) {
                this.encoding.onSupport(solver, scope, this.valuemapping);
            } else {
                this.encoding.onNogood(solver, scope, this.valuemapping);
            }
        } else {
            Var var = scope.get(n);
            Domain domain = var.domain();
            int i = 0;
            while (i < domain.size()) {
                this.valuemapping.put(var, domain.get(i));
                this.find(tuple, n + 1, scope, vars, solver);
                ++i;
            }
            this.valuemapping.remove(var);
        }
    }
}

