/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.csp;

import java.util.NoSuchElementException;
import org.sat4j.csp.Domain;
import org.sat4j.specs.IteratorInt;

public class RangeDomain
implements Domain {
    private final int begin;
    private final int end;
    private final int size;

    public RangeDomain(int begin, int end) {
        this.begin = begin;
        this.end = end;
        this.size = end - begin + 1;
    }

    @Override
    public int get(int i) {
        assert (i >= 0);
        return this.begin + i;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public IteratorInt iterator() {
        return new IteratorInt(){
            private int i;
            {
                this.i = RangeDomain.this.begin;
            }

            @Override
            public boolean hasNext() {
                return this.i <= RangeDomain.this.end;
            }

            @Override
            public int next() {
                if (this.i > RangeDomain.this.end) {
                    throw new NoSuchElementException();
                }
                return this.i++;
            }
        };
    }

    @Override
    public int pos(int value) {
        return value - this.begin;
    }
}

