/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.csp;

import org.sat4j.core.VecInt;
import org.sat4j.csp.Domain;
import org.sat4j.csp.Evaluable;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.ISolver;

public class Var
implements Evaluable {
    private final Domain domain;
    private final String id;
    private final int startid;

    public Var(String idvar, Domain domain, int lastvarnumber) {
        this.domain = domain;
        this.id = idvar;
        this.startid = lastvarnumber + 1;
    }

    @Override
    public Domain domain() {
        return this.domain;
    }

    @Override
    public int translate(int key) {
        return this.domain.pos(key) + this.startid;
    }

    @Override
    public void toClause(ISolver solver) throws ContradictionException {
        VecInt clause = new VecInt(this.domain.size());
        int i = 0;
        while (i < this.domain.size()) {
            clause.push(i + this.startid);
            ++i;
        }
        solver.addClause(clause);
        solver.addAtMost(clause, 1);
    }

    public int findValue(int[] model) {
        int i = 0;
        while (i < this.domain.size()) {
            int varnum = i + this.startid;
            if (model[varnum - 1] == varnum) {
                return this.domain.get(i);
            }
            ++i;
        }
        throw new RuntimeException("BIG PROBLEM: no value for a var!");
    }

    public String toString() {
        return this.id;
    }
}

