/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.csp.encodings;

import java.util.HashMap;
import java.util.Map;
import org.sat4j.core.VecInt;
import org.sat4j.csp.Encoding;
import org.sat4j.csp.Evaluable;
import org.sat4j.csp.Var;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.IteratorInt;

public class BinarySupportEncoding
implements Encoding {
    private final Map<Integer, IVecInt> supportsa = new HashMap<Integer, IVecInt>();
    private final Map<Integer, IVecInt> supportsb = new HashMap<Integer, IVecInt>();
    private static final Encoding instance = new BinarySupportEncoding();

    private BinarySupportEncoding() {
    }

    public static Encoding instance() {
        return instance;
    }

    @Override
    public void onFinish(ISolver solver, IVec<Var> scope) throws ContradictionException {
        this.generateClauses(scope.get(0), this.supportsa, solver);
        this.generateClauses(scope.get(1), this.supportsb, solver);
    }

    @Override
    public void onInit(ISolver solver, IVec<Var> scope) {
        this.supportsa.clear();
        this.supportsb.clear();
    }

    @Override
    public void onNogood(ISolver solver, IVec<Var> scope, Map<Evaluable, Integer> tuple) throws ContradictionException {
    }

    @Override
    public void onSupport(ISolver solver, IVec<Var> scope, Map<Evaluable, Integer> tuple) throws ContradictionException {
        Var vara = scope.get(0);
        Integer va = tuple.get(vara);
        Var varb = scope.get(1);
        Integer vb = tuple.get(varb);
        this.addSupport(va, varb, vb, this.supportsa);
        this.addSupport(vb, vara, va, this.supportsb);
    }

    private void addSupport(Integer head, Evaluable v, Integer value, Map<Integer, IVecInt> supports) {
        IVecInt sup = supports.get(head);
        if (sup == null) {
            sup = new VecInt();
            supports.put(head, sup);
        }
        sup.push(v.translate(value));
    }

    private void generateClauses(Evaluable v, Map<Integer, IVecInt> supports, ISolver solver) throws ContradictionException {
        VecInt clause = new VecInt();
        IteratorInt it = v.domain().iterator();
        while (it.hasNext()) {
            Integer key = new Integer(it.next());
            clause.clear();
            IVecInt support = supports.get(key);
            clause.push(-v.translate(key));
            if (support != null) {
                IteratorInt iterator = support.iterator();
                while (iterator.hasNext()) {
                    clause.push(iterator.next());
                }
            }
            solver.addClause(clause);
        }
    }
}

