/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.csp.xml;

import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.sat4j.csp.xml.CSPFormatException;
import org.sat4j.csp.xml.ConstantParameter;
import org.sat4j.csp.xml.Constraint;
import org.sat4j.csp.xml.Constraints;
import org.sat4j.csp.xml.Domain;
import org.sat4j.csp.xml.Domains;
import org.sat4j.csp.xml.Element;
import org.sat4j.csp.xml.Expression;
import org.sat4j.csp.xml.Functional;
import org.sat4j.csp.xml.ICSPCallback;
import org.sat4j.csp.xml.Instance;
import org.sat4j.csp.xml.ListOfParameters;
import org.sat4j.csp.xml.Parameters;
import org.sat4j.csp.xml.Predicate;
import org.sat4j.csp.xml.Predicates;
import org.sat4j.csp.xml.Presentation;
import org.sat4j.csp.xml.Relation;
import org.sat4j.csp.xml.Relations;
import org.sat4j.csp.xml.Variable;
import org.sat4j.csp.xml.Variables;
import org.xml.sax.Attributes;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

class InstanceParser
extends DefaultHandler {
    private Vector<Element> parents = new Vector();
    private Map<String, Element> theElts = new HashMap<String, Element>();

    public InstanceParser(ICSPCallback cb) {
        this.theElts.put("instance", new Instance(cb, "instance"));
        this.theElts.put("presentation", new Presentation(cb, "presentation"));
        this.theElts.put("domains", new Domains(cb, "domains"));
        this.theElts.put("domain", new Domain(cb, "domain"));
        this.theElts.put("variables", new Variables(cb, "variables"));
        this.theElts.put("variable", new Variable(cb, "variable"));
        this.theElts.put("relations", new Relations(cb, "relations"));
        this.theElts.put("relation", new Relation(cb, "relation"));
        this.theElts.put("predicates", new Predicates(cb, "predicates"));
        this.theElts.put("predicate", new Predicate(cb, "predicate"));
        this.theElts.put("parameters", new Parameters(cb, "parameters", this));
        this.theElts.put("expression", new Expression(cb, "expression"));
        this.theElts.put("functional", new Functional(cb, "functional"));
        this.theElts.put("constraints", new Constraints(cb, "constraints"));
        this.theElts.put("constraint", new Constraint(cb, "constraint"));
        this.theElts.put("list", new ListOfParameters(cb, "list"));
        this.theElts.put("cst", new ConstantParameter(cb, "cst"));
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.parents.lastElement().characters(new String(ch, start, length));
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        Element current = this.theElts.get(qName);
        if (current != null) {
            current.endElement();
            assert (current.tagName().equals(this.parents.lastElement().tagName()));
        } else {
            throw new CSPFormatException(String.valueOf(qName) + " : undefined tag");
        }
        this.parents.remove(this.parents.size() - 1);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) {
        Element current = this.theElts.get(qName);
        if (current == null) {
            throw new CSPFormatException(String.valueOf(qName) + " : undefined tag");
        }
        this.parents.add(current);
        current.startElement(atts);
    }

    public Element getParentElement() {
        if (this.parents.size() >= 2) {
            return this.parents.get(this.parents.size() - 2);
        }
        return null;
    }

    @Override
    public void error(SAXParseException exception) {
        System.out.println("error");
        System.out.println(exception.getMessage());
        System.out.println(exception);
        System.out.println("Colonne : " + exception.getColumnNumber() + " Ligne : " + exception.getLineNumber());
        System.exit(1);
    }

    @Override
    public void fatalError(SAXParseException exception) {
        System.out.println("fatalError");
        System.out.println(exception.getMessage());
        System.out.println(exception);
        System.out.println("Colonne : " + exception.getColumnNumber() + " Ligne : " + exception.getLineNumber());
        System.exit(1);
    }

    @Override
    public void warning(SAXParseException exception) {
        System.out.println("warning");
        System.out.println(exception.getMessage());
        System.out.println(exception);
        System.out.println("Colonne : " + exception.getColumnNumber() + " Ligne : " + exception.getLineNumber());
    }
}

