/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.csp.xml;

import org.sat4j.csp.xml.CSPFormatException;
import org.sat4j.csp.xml.Element;
import org.sat4j.csp.xml.ICSPCallback;
import org.sat4j.csp.xml.InstanceParser;
import org.xml.sax.Attributes;

class Parameters
extends Element {
    private StringBuilder allParameters;
    private InstanceParser ip;

    public Parameters(ICSPCallback out, String tagName, InstanceParser ip) {
        super(out, tagName);
        this.ip = ip;
    }

    @Override
    public void startElement(Attributes att) {
        this.allParameters = new StringBuilder();
    }

    @Override
    public void characters(String s) {
        this.allParameters.append(s);
    }

    @Override
    public void endElement() {
        if (this.ip.getParentElement().tagName().equals("constraint")) {
            this.effectiveParameters();
        } else {
            this.formalParameters();
        }
    }

    private void formalParameters() {
        String[] tokens = this.allParameters.toString().trim().split("\\s+");
        int i = 0;
        while (i < tokens.length && !tokens[i].equals("")) {
            String type = tokens[i];
            if (!type.equals("int")) {
                throw new CSPFormatException(String.valueOf(type) + " type for parameters not supported");
            }
            if (++i == tokens.length || tokens[i].equals("")) {
                throw new CSPFormatException("a parameter name is missing.");
            }
            String name = tokens[i];
            this.getCB().addFormalParameter(name, type);
            ++i;
        }
    }

    private void effectiveParameters() {
        String[] tokens;
        String[] stringArray = tokens = this.allParameters.toString().trim().split("\\s+");
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            String tok = stringArray[n2];
            if (!tok.equals("")) {
                try {
                    this.getCB().addEffectiveParameter(Integer.parseInt(tok));
                }
                catch (NumberFormatException e) {
                    this.getCB().addEffectiveParameter(tok);
                }
            }
            ++n2;
        }
    }
}

