/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.constraints;

import org.sat4j.minisat.constraints.AbstractDataStructureFactory;
import org.sat4j.minisat.constraints.cnf.LearntWLClause;
import org.sat4j.minisat.constraints.cnf.Lits2;
import org.sat4j.minisat.constraints.cnf.WLClause;
import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.ILits2;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IVecInt;

public class MixedDataStructureWithBinary
extends AbstractDataStructureFactory<ILits2> {
    private static final long serialVersionUID = 1L;

    @Override
    public ILits2 createLits() {
        return new Lits2();
    }

    @Override
    public Constr createClause(IVecInt literals) throws ContradictionException {
        IVecInt v = WLClause.sanityCheck(literals, this.lits, this.solver);
        if (v == null) {
            return null;
        }
        if (v.size() == 2) {
            ((ILits2)this.lits).binaryClauses(v.get(0), v.get(1));
            return null;
        }
        return WLClause.brandNewClause(this.solver, this.lits, v);
    }

    @Override
    public void learnConstraint(Constr constr) {
        if (constr.size() == 2) {
            ((ILits2)this.lits).binaryClauses(constr.get(0), constr.get(1));
        } else {
            super.learnConstraint(constr);
        }
    }

    @Override
    public Constr createUnregisteredClause(IVecInt literals) {
        return new LearntWLClause(literals, (ILits)this.getVocabulary());
    }
}

