/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.constraints;

import org.sat4j.minisat.constraints.AbstractDataStructureFactory;
import org.sat4j.minisat.constraints.cnf.LearntWLClause;
import org.sat4j.minisat.constraints.cnf.Lits23;
import org.sat4j.minisat.constraints.cnf.WLClause;
import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.ILits23;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IVecInt;

public class MixedDataStructureWithBinaryAndTernary
extends AbstractDataStructureFactory<ILits23> {
    private static final long serialVersionUID = 1L;

    @Override
    public Constr createClause(IVecInt literals) throws ContradictionException {
        IVecInt v = WLClause.sanityCheck(literals, this.lits, this.solver);
        if (v == null) {
            return null;
        }
        if (v.size() == 2) {
            ((ILits23)this.lits).binaryClauses(v.get(0), v.get(1));
            return null;
        }
        if (v.size() == 3) {
            ((ILits23)this.lits).ternaryClauses(v.get(0), v.get(1), v.get(2));
            return null;
        }
        return WLClause.brandNewClause(this.solver, this.lits, v);
    }

    @Override
    public void learnConstraint(Constr constr) {
        if (constr.size() == 2) {
            ((ILits23)this.lits).binaryClauses(constr.get(0), constr.get(1));
        } else if (constr.size() == 3) {
            ((ILits23)this.lits).ternaryClauses(constr.get(0), constr.get(1), constr.get(2));
        } else {
            super.learnConstraint(constr);
        }
    }

    @Override
    protected ILits23 createLits() {
        return new Lits23();
    }

    @Override
    public Constr createUnregisteredClause(IVecInt literals) {
        return new LearntWLClause(literals, (ILits)this.getVocabulary());
    }
}

