/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.constraints.cnf;

import java.io.Serializable;
import org.sat4j.core.VecInt;
import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.UnitPropagationListener;
import org.sat4j.specs.IVecInt;

public class BinaryClauses
implements Constr,
Serializable {
    private static final long serialVersionUID = 1L;
    private final ILits voc;
    private final IVecInt clauses = new VecInt();
    private final int reason;
    private int conflictindex = -1;

    public BinaryClauses(ILits voc, int p) {
        this.voc = voc;
        this.reason = p;
    }

    public void addBinaryClause(int p) {
        this.clauses.push(p);
    }

    @Override
    public void remove() {
    }

    @Override
    public boolean propagate(UnitPropagationListener s, int p) {
        this.voc.watch(p, this);
        int i = 0;
        while (i < this.clauses.size()) {
            int q = this.clauses.get(i);
            if (!s.enqueue(q, this)) {
                this.conflictindex = i;
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public boolean simplify() {
        IVecInt locclauses = this.clauses;
        int size = this.clauses.size();
        int i = 0;
        while (i < size) {
            if (this.voc.isSatisfied(locclauses.get(i))) {
                return true;
            }
            if (this.voc.isFalsified(locclauses.get(i))) {
                locclauses.delete(i);
            }
            ++i;
        }
        return false;
    }

    public void undo(int p) {
    }

    @Override
    public void calcReason(int p, IVecInt outReason) {
        outReason.push(this.reason ^ 1);
        if (p == -1) {
            assert (this.conflictindex > -1);
            outReason.push(this.clauses.get(this.conflictindex) ^ 1);
        }
    }

    @Override
    public boolean learnt() {
        return false;
    }

    @Override
    public void incActivity(double claInc) {
    }

    @Override
    public double getActivity() {
        return 0.0;
    }

    @Override
    public boolean locked() {
        return false;
    }

    @Override
    public void setLearnt() {
    }

    @Override
    public void register() {
    }

    @Override
    public void rescaleBy(double d) {
    }

    @Override
    public int size() {
        return this.clauses.size();
    }

    @Override
    public int get(int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void assertConstraint(UnitPropagationListener s) {
        throw new UnsupportedOperationException();
    }
}

