/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.constraints.cnf;

import java.util.HashSet;
import java.util.Set;
import org.sat4j.core.VecInt;
import org.sat4j.minisat.constraints.cnf.Lits;
import org.sat4j.minisat.core.IMarkableLits;
import org.sat4j.specs.IVecInt;

public class MarkableLits
extends Lits
implements IMarkableLits {
    private static final long serialVersionUID = 1L;
    private int[] marks;
    private static final int DEFAULTMARK = 1;

    @Override
    public void init(int nvar) {
        super.init(nvar);
        this.marks = new int[(nvar << 1) + 2];
    }

    @Override
    public void setMark(int p, int mark) {
        assert (this.marks != null);
        assert (p > 1);
        assert (p < this.marks.length);
        this.marks[p] = mark;
    }

    @Override
    public void setMark(int p) {
        this.setMark(p, 1);
    }

    @Override
    public int getMark(int p) {
        return this.marks[p];
    }

    @Override
    public boolean isMarked(int p) {
        return this.marks[p] != 0;
    }

    @Override
    public void resetMark(int p) {
        this.marks[p] = 0;
    }

    @Override
    public void resetAllMarks() {
        int i = 2;
        while (i < this.marks.length) {
            this.resetMark(i);
            ++i;
        }
    }

    @Override
    public IVecInt getMarkedLiterals() {
        VecInt marked = new VecInt();
        int i = 2;
        while (i < this.marks.length) {
            if (this.isMarked(i)) {
                marked.push(i);
            }
            ++i;
        }
        return marked;
    }

    @Override
    public IVecInt getMarkedLiterals(int mark) {
        VecInt marked = new VecInt();
        int i = 2;
        while (i < this.marks.length) {
            if (this.getMark(i) == mark) {
                marked.push(i);
            }
            ++i;
        }
        return marked;
    }

    @Override
    public IVecInt getMarkedVariables() {
        VecInt marked = new VecInt();
        int i = 2;
        while (i < this.marks.length) {
            if (this.isMarked(i) || this.isMarked(i + 1)) {
                marked.push(i >> 1);
            }
            i += 2;
        }
        return marked;
    }

    @Override
    public IVecInt getMarkedVariables(int mark) {
        VecInt marked = new VecInt();
        int i = 2;
        while (i < this.marks.length) {
            if (this.getMark(i) == mark || this.getMark(i + 1) == mark) {
                marked.push(i >> 1);
            }
            i += 2;
        }
        return marked;
    }

    @Override
    public Set<Integer> getMarks() {
        HashSet<Integer> markers = new HashSet<Integer>();
        int[] nArray = this.marks;
        int n = this.marks.length;
        int n2 = 0;
        while (n2 < n) {
            int m = nArray[n2];
            if (m != 0) {
                markers.add(m);
            }
            ++n2;
        }
        return markers;
    }
}

