/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.core;

import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.io.Writer;
import org.sat4j.core.Vec;
import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.Lbool;
import org.sat4j.minisat.core.SearchListener;

public class DotSearchListener
implements SearchListener {
    private static final long serialVersionUID = 1L;
    private final Vec<String> pile = new Vec();
    private String currentNodeName = null;
    private transient Writer out;
    private boolean estOrange = false;

    public DotSearchListener(String fileNameToSave) {
        try {
            this.out = new FileWriter(fileNameToSave);
        }
        catch (IOException e) {
            System.err.println("Problem when created file.");
        }
    }

    @Override
    public final void assuming(int p) {
        String newName;
        int absP = Math.abs(p);
        if (this.currentNodeName == null) {
            newName = "" + absP;
            this.pile.push(newName);
            this.saveLine(this.lineTab("\"" + newName + "\"" + "[label=\"" + newName + "\", shape=circle, color=blue, style=filled]"));
        } else {
            newName = this.currentNodeName;
            this.pile.push(newName);
            this.saveLine(this.lineTab("\"" + newName + "\"" + "[label=\"" + absP + "\", shape=circle, color=blue, style=filled]"));
        }
        this.currentNodeName = newName;
    }

    @Override
    public final void propagating(int p) {
        String newName = String.valueOf(this.currentNodeName) + "." + p;
        if (this.currentNodeName == null) {
            this.saveLine(this.lineTab("\"null\" [label=\"\", shape=point]"));
        }
        String couleur = this.estOrange ? "orange" : "green";
        this.saveLine(this.lineTab("\"" + newName + "\"" + "[label=\"" + Integer.toString(p) + "\",shape=point, color=black]"));
        this.saveLine(this.lineTab("\"" + this.currentNodeName + "\"" + " -- " + "\"" + newName + "\"" + "[label=" + "\" " + Integer.toString(p) + "\", fontcolor =" + couleur + ", color = " + couleur + ", style = bold]"));
        this.currentNodeName = newName;
        this.estOrange = false;
    }

    @Override
    public final void backtracking(int p) {
        String temp = this.pile.last();
        this.pile.pop();
        this.saveLine("\"" + temp + "\"" + "--" + "\"" + this.currentNodeName + "\"" + "[label=\"\", color=red, style=dotted]");
        this.currentNodeName = temp;
    }

    @Override
    public final void adding(int p) {
        this.estOrange = true;
    }

    @Override
    public final void learn(Constr clause) {
    }

    @Override
    public final void delete(int[] clause) {
    }

    @Override
    public final void conflictFound() {
        this.saveLine(this.lineTab("\"" + this.currentNodeName + "\" [label=\"\", shape=box, color=\"red\", style=filled]"));
    }

    @Override
    public final void solutionFound() {
        this.saveLine(this.lineTab("\"" + this.currentNodeName + "\" [label=\"\", shape=box, color=\"green\", style=filled]"));
    }

    @Override
    public final void beginLoop() {
    }

    @Override
    public final void start() {
        this.saveLine("graph G {");
    }

    @Override
    public final void end(Lbool result) {
        this.saveLine("}");
    }

    private final String lineTab(String line) {
        return "\t" + line;
    }

    private final void saveLine(String line) {
        try {
            this.out.write(String.valueOf(line) + '\n');
            if ("}".equals(line)) {
                this.out.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.out = new PrintWriter(System.out);
    }
}

