/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.core;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.sat4j.core.LiteralsUtils;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.minisat.core.ActivityComparator;
import org.sat4j.minisat.core.ActivityListener;
import org.sat4j.minisat.core.AssertingClauseGenerator;
import org.sat4j.minisat.core.ConflictTimer;
import org.sat4j.minisat.core.ConflictTimerAdapter;
import org.sat4j.minisat.core.ConflictTimerContainer;
import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.DataStructureFactory;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.IOrder;
import org.sat4j.minisat.core.Lbool;
import org.sat4j.minisat.core.Learner;
import org.sat4j.minisat.core.LearningStrategy;
import org.sat4j.minisat.core.NullSearchListener;
import org.sat4j.minisat.core.Pair;
import org.sat4j.minisat.core.Propagatable;
import org.sat4j.minisat.core.RestartStrategy;
import org.sat4j.minisat.core.SearchListener;
import org.sat4j.minisat.core.SearchParams;
import org.sat4j.minisat.core.SolverStats;
import org.sat4j.minisat.core.UnitPropagationListener;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.IteratorInt;
import org.sat4j.specs.TimeoutException;

public class Solver<L extends ILits, D extends DataStructureFactory<L>>
implements ISolver,
UnitPropagationListener,
ActivityListener,
Learner {
    private static final long serialVersionUID = 1L;
    private static final double CLAUSE_RESCALE_FACTOR = 1.0E-20;
    private static final double CLAUSE_RESCALE_BOUND = 1.0E20;
    private final IVec<Constr> constrs = new Vec<Constr>();
    private final IVec<Constr> learnts = new Vec<Constr>();
    private double claInc = 1.0;
    private double claDecay = 1.0;
    private int qhead = 0;
    protected final IVecInt trail = new VecInt();
    protected final IVecInt trailLim = new VecInt();
    protected int rootLevel;
    private int[] model = null;
    protected L voc;
    private IOrder<L> order;
    private final ActivityComparator comparator = new ActivityComparator();
    private final SolverStats stats = new SolverStats();
    private final LearningStrategy<L, D> learner;
    protected final AssertingClauseGenerator analyzer;
    private volatile boolean undertimeout;
    private long timeout = Integer.MAX_VALUE;
    private boolean timeBasedTimeout = true;
    protected D dsfactory;
    private SearchParams params;
    private final IVecInt __dimacs_out = new VecInt();
    private SearchListener slistener = new NullSearchListener();
    private RestartStrategy restarter;
    private final Map<String, Integer> constrTypes = new HashMap<String, Integer>();
    private boolean isDBSimplificationAllowed = false;
    private int learnedLiterals = 0;
    private boolean[] mseen = new boolean[0];
    private final IVecInt preason = new VecInt();
    private final IVecInt outLearnt = new VecInt();
    public static final ISimplifier NO_SIMPLIFICATION = new ISimplifier(){
        private static final long serialVersionUID = 1L;

        @Override
        public void simplify(IVecInt outLearnt) {
        }

        public String toString() {
            return "No reason simplification";
        }
    };
    public final ISimplifier SIMPLE_SIMPLIFICATION = new ISimplifier(){
        private static final long serialVersionUID = 1L;

        @Override
        public void simplify(IVecInt outLearnt) {
            Solver.this.simpleSimplification(outLearnt);
        }

        public String toString() {
            return "Simple reason simplification";
        }
    };
    public final ISimplifier EXPENSIVE_SIMPLIFICATION = new ISimplifier(){
        private static final long serialVersionUID = 1L;

        @Override
        public void simplify(IVecInt outLearnt) {
            Solver.this.expensiveSimplification(outLearnt);
        }

        public String toString() {
            return "Expensive reason simplification";
        }
    };
    private ISimplifier simplifier = NO_SIMPLIFICATION;
    private final IVecInt analyzetoclear = new VecInt();
    private final IVecInt analyzestack = new VecInt();
    private final Pair analysisResult = new Pair();
    private boolean[] fullmodel;
    private double timebegin = 0.0;
    private boolean needToReduceDB;
    private ConflictTimer conflictCount;
    private transient Timer timer;

    protected IVecInt dimacs2internal(IVecInt in) {
        this.__dimacs_out.clear();
        this.__dimacs_out.ensure(in.size());
        int i = 0;
        while (i < in.size()) {
            assert (in.get(i) != 0);
            this.__dimacs_out.unsafePush(this.voc.getFromPool(in.get(i)));
            ++i;
        }
        return this.__dimacs_out;
    }

    public Solver(AssertingClauseGenerator acg, LearningStrategy<L, D> learner, D dsf, IOrder<L> order, RestartStrategy restarter) {
        this(acg, learner, dsf, new SearchParams(), order, restarter);
    }

    public Solver(AssertingClauseGenerator acg, LearningStrategy<L, D> learner, D dsf, SearchParams params, IOrder<L> order, RestartStrategy restarter) {
        this.analyzer = acg;
        this.learner = learner;
        this.order = order;
        this.params = params;
        this.setDataStructureFactory(dsf);
        this.restarter = restarter;
    }

    public final void setDataStructureFactory(D dsf) {
        this.dsfactory = dsf;
        this.dsfactory.setUnitPropagationListener(this);
        this.dsfactory.setLearner(this);
        this.voc = dsf.getVocabulary();
        this.order.setLits(this.voc);
    }

    public void setSearchListener(SearchListener sl) {
        this.slistener = sl;
    }

    @Override
    public void setTimeout(int t) {
        this.timeout = (long)t * 1000L;
        this.timeBasedTimeout = true;
    }

    @Override
    public void setTimeoutMs(long t) {
        this.timeout = t;
        this.timeBasedTimeout = true;
    }

    @Override
    public void setTimeoutOnConflicts(int count) {
        this.timeout = count;
        this.timeBasedTimeout = false;
    }

    public void setSearchParams(SearchParams sp) {
        this.params = sp;
    }

    public void setRestartStrategy(RestartStrategy restarter) {
        this.restarter = restarter;
    }

    @Override
    public void expireTimeout() {
        this.undertimeout = false;
    }

    protected int nAssigns() {
        return this.trail.size();
    }

    @Override
    public int nConstraints() {
        return this.constrs.size() + this.trail.size();
    }

    @Override
    public void learn(Constr c) {
        this.learnts.push(c);
        c.setLearnt();
        c.register();
        ++this.stats.learnedclauses;
        switch (c.size()) {
            case 2: {
                ++this.stats.learnedbinaryclauses;
                break;
            }
            case 3: {
                ++this.stats.learnedternaryclauses;
            }
        }
    }

    public int decisionLevel() {
        return this.trailLim.size();
    }

    @Override
    @Deprecated
    public int newVar() {
        int index = this.voc.nVars() + 1;
        this.voc.ensurePool(index);
        return index;
    }

    @Override
    public int newVar(int howmany) {
        this.voc.ensurePool(howmany);
        return this.voc.nVars();
    }

    @Override
    public IConstr addClause(IVecInt literals) throws ContradictionException {
        IVecInt vlits = this.dimacs2internal(literals);
        return this.addConstr(this.dsfactory.createClause(vlits));
    }

    @Override
    public boolean removeConstr(IConstr co) {
        if (co == null) {
            throw new UnsupportedOperationException("Reference to the constraint to remove needed!");
        }
        Constr c = (Constr)co;
        c.remove();
        this.constrs.remove(c);
        this.clearLearntClauses();
        this.cancelLearntLiterals();
        return true;
    }

    @Override
    public void addAllClauses(IVec<IVecInt> clauses) throws ContradictionException {
        Iterator<IVecInt> iterator = clauses.iterator();
        while (iterator.hasNext()) {
            this.addClause(iterator.next());
        }
    }

    @Override
    public IConstr addAtMost(IVecInt literals, int degree) throws ContradictionException {
        int n = literals.size();
        VecInt opliterals = new VecInt(n);
        IteratorInt iterator = literals.iterator();
        while (iterator.hasNext()) {
            opliterals.push(-iterator.next());
        }
        return this.addAtLeast(opliterals, n - degree);
    }

    @Override
    public IConstr addAtLeast(IVecInt literals, int degree) throws ContradictionException {
        IVecInt vlits = this.dimacs2internal(literals);
        return this.addConstr(this.dsfactory.createCardinalityConstraint(vlits, degree));
    }

    public boolean simplifyDB() {
        IVec[] cs = new IVec[]{this.constrs, this.learnts};
        int type = 0;
        while (type < 2) {
            int j = 0;
            int i = 0;
            while (i < cs[type].size()) {
                if (((Constr)cs[type].get(i)).simplify()) {
                    ((Constr)cs[type].get(i)).remove();
                } else {
                    cs[type].moveTo(j++, i);
                }
                ++i;
            }
            cs[type].shrinkTo(j);
            ++type;
        }
        return true;
    }

    @Override
    public int[] model() {
        if (this.model == null) {
            throw new UnsupportedOperationException("Call the solve method first!!!");
        }
        int[] nmodel = new int[this.model.length];
        System.arraycopy(this.model, 0, nmodel, 0, this.model.length);
        return nmodel;
    }

    @Override
    public boolean enqueue(int p) {
        return this.enqueue(p, null);
    }

    @Override
    public boolean enqueue(int p, Constr from) {
        assert (p > 1);
        if (this.voc.isSatisfied(p)) {
            return true;
        }
        if (this.voc.isFalsified(p)) {
            return false;
        }
        this.voc.satisfies(p);
        this.voc.setLevel(p, this.decisionLevel());
        this.voc.setReason(p, from);
        this.trail.push(p);
        return true;
    }

    public void analyze(Constr confl, Pair results) {
        assert (confl != null);
        this.outLearnt.clear();
        boolean[] seen = this.mseen;
        assert (this.outLearnt.size() == 0);
        int i = 0;
        while (i < seen.length) {
            seen[i] = false;
            ++i;
        }
        this.analyzer.initAnalyze();
        int p = -1;
        this.outLearnt.push(-1);
        int outBtlevel = 0;
        do {
            this.preason.clear();
            assert (confl != null);
            confl.calcReason(p, this.preason);
            if (confl.learnt()) {
                this.claBumpActivity(confl);
            }
            int j = 0;
            while (j < this.preason.size()) {
                int q = this.preason.get(j);
                this.order.updateVar(q);
                if (!seen[q >> 1]) {
                    seen[q >> 1] = true;
                    if (this.voc.getLevel(q) == this.decisionLevel()) {
                        this.analyzer.onCurrentDecisionLevelLiteral(q);
                    } else if (this.voc.getLevel(q) > 0) {
                        this.outLearnt.push(q ^ 1);
                        outBtlevel = Math.max(outBtlevel, this.voc.getLevel(q));
                    }
                }
                ++j;
            }
            do {
                p = this.trail.last();
                confl = this.voc.getReason(p);
                this.undoOne();
            } while (!seen[p >> 1]);
        } while (this.analyzer.clauseNonAssertive(confl));
        this.outLearnt.set(0, p ^ 1);
        this.simplifier.simplify(this.outLearnt);
        Constr c = this.dsfactory.createUnregisteredClause(this.outLearnt);
        this.slistener.learn(c);
        results.reason = c;
        assert (outBtlevel > -1);
        results.backtrackLevel = outBtlevel;
    }

    public void setSimplifier(String simp) {
        try {
            Field f = Solver.class.getDeclaredField(simp);
            this.simplifier = (ISimplifier)f.get(this);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.simplifier = NO_SIMPLIFICATION;
        }
    }

    public void setSimplifier(ISimplifier simp) {
        this.simplifier = simp;
    }

    private void simpleSimplification(IVecInt outLearnt) {
        boolean[] seen = this.mseen;
        int j = 1;
        int i = 1;
        while (i < outLearnt.size()) {
            Constr r = this.voc.getReason(outLearnt.get(i));
            if (r == null) {
                outLearnt.moveTo(j++, i);
            } else {
                int k = 0;
                while (k < r.size()) {
                    if (this.voc.isFalsified(r.get(k)) && !seen[r.get(k) >> 1] && this.voc.getLevel(r.get(k)) != 0) {
                        outLearnt.moveTo(j++, i);
                        break;
                    }
                    ++k;
                }
            }
            ++i;
        }
        outLearnt.shrink(i - j);
        this.stats.reducedliterals += (long)(i - j);
    }

    private void expensiveSimplification(IVecInt outLearnt) {
        this.analyzetoclear.clear();
        outLearnt.copyTo(this.analyzetoclear);
        int i = 1;
        int j = 1;
        while (i < outLearnt.size()) {
            if (this.voc.getReason(outLearnt.get(i)) == null || !this.analyzeRemovable(outLearnt.get(i))) {
                outLearnt.moveTo(j++, i);
            }
            ++i;
        }
        outLearnt.shrink(i - j);
        this.stats.reducedliterals += (long)(i - j);
    }

    private boolean analyzeRemovable(int p) {
        assert (this.voc.getReason(p) != null);
        this.analyzestack.clear();
        this.analyzestack.push(p);
        boolean[] seen = this.mseen;
        int top = this.analyzetoclear.size();
        while (this.analyzestack.size() > 0) {
            int q = this.analyzestack.last();
            assert (this.voc.getReason(q) != null);
            Constr c = this.voc.getReason(q);
            this.analyzestack.pop();
            int i = 0;
            while (i < c.size()) {
                int l = c.get(i);
                if (this.voc.isFalsified(l) && !seen[LiteralsUtils.var(l)] && this.voc.getLevel(l) != 0) {
                    if (this.voc.getReason(l) == null) {
                        int j = top;
                        while (j < this.analyzetoclear.size()) {
                            seen[this.analyzetoclear.get((int)j) >> 1] = false;
                            ++j;
                        }
                        this.analyzetoclear.shrink(this.analyzetoclear.size() - top);
                        return false;
                    }
                    seen[l >> 1] = true;
                    this.analyzestack.push(l);
                    this.analyzetoclear.push(l);
                }
                ++i;
            }
        }
        return true;
    }

    public static int decode2dimacs(int p) {
        return ((p & 1) == 0 ? 1 : -1) * (p >> 1);
    }

    /*
     * Unable to fully structure code
     */
    protected void undoOne() {
        p = this.trail.last();
        if (!Solver.$assertionsDisabled && p <= 1) {
            throw new AssertionError();
        }
        if (!Solver.$assertionsDisabled && this.voc.getLevel(p) < 0) {
            throw new AssertionError();
        }
        x = p >> 1;
        this.voc.unassign(p);
        this.voc.setReason(p, null);
        this.voc.setLevel(p, -1);
        this.order.undo(x);
        this.trail.pop();
        undos = this.voc.undos(p);
        if (Solver.$assertionsDisabled || undos != null) ** GOTO lbl18
        throw new AssertionError();
lbl-1000:
        // 1 sources

        {
            undos.last().undo(p);
            undos.pop();
lbl18:
            // 2 sources

            ** while (undos.size() > 0)
        }
lbl19:
        // 1 sources

    }

    @Override
    public void claBumpActivity(Constr confl) {
        confl.incActivity(this.claInc);
        if (confl.getActivity() > 1.0E20) {
            this.claRescalActivity();
        }
    }

    @Override
    public void varBumpActivity(int p) {
        this.order.updateVar(p);
    }

    private void claRescalActivity() {
        int i = 0;
        while (i < this.learnts.size()) {
            this.learnts.get(i).rescaleBy(1.0E-20);
            ++i;
        }
        this.claInc *= 1.0E-20;
    }

    public Constr propagate() {
        while (this.qhead < this.trail.size()) {
            ++this.stats.propagations;
            int p = this.trail.get(this.qhead++);
            this.slistener.propagating(Solver.decode2dimacs(p));
            this.order.assignLiteral(p);
            assert (p > 1);
            IVec<Propagatable> constrs = this.dsfactory.getWatchesFor(p);
            int size = constrs.size();
            int i = 0;
            while (i < size) {
                ++this.stats.inspects;
                if (!constrs.get(i).propagate(this, p)) {
                    this.dsfactory.conflictDetectedInWatchesFor(p, i);
                    this.qhead = this.trail.size();
                    return (Constr)constrs.get(i);
                }
                ++i;
            }
        }
        return null;
    }

    void record(Constr constr) {
        constr.assertConstraint(this);
        this.slistener.adding(Solver.decode2dimacs(constr.get(0)));
        if (constr.size() == 1) {
            ++this.stats.learnedliterals;
            ++this.learnedLiterals;
        } else {
            this.learner.learns(constr);
        }
    }

    public boolean assume(int p) {
        assert (this.trail.size() == this.qhead);
        this.trailLim.push(this.trail.size());
        return this.enqueue(p);
    }

    private void cancel() {
        int decisionvar = this.trail.unsafeGet(this.trailLim.last());
        this.slistener.backtracking(Solver.decode2dimacs(decisionvar));
        int c = this.trail.size() - this.trailLim.last();
        while (c > 0) {
            this.undoOne();
            --c;
        }
        this.trailLim.pop();
    }

    private void cancelLearntLiterals() {
        int c = this.learnedLiterals;
        while (c > 0) {
            this.undoOne();
            --c;
        }
        this.qhead = this.trail.size();
    }

    protected void cancelUntil(int level) {
        while (this.decisionLevel() > level) {
            this.cancel();
        }
        this.qhead = this.trail.size();
    }

    Lbool search(long nofConflicts) {
        assert (this.rootLevel == this.decisionLevel());
        ++this.stats.starts;
        int conflictC = 0;
        this.order.setVarDecay(1.0 / this.params.getVarDecay());
        this.claDecay = 1.0 / this.params.getClaDecay();
        do {
            this.slistener.beginLoop();
            Constr confl = this.propagate();
            assert (this.trail.size() == this.qhead);
            if (confl == null) {
                if (this.decisionLevel() == 0 && this.isDBSimplificationAllowed) {
                    ++this.stats.rootSimplifications;
                    boolean ret = this.simplifyDB();
                    assert (ret);
                }
                assert (this.nAssigns() <= this.voc.realnVars());
                if (this.nAssigns() == this.voc.realnVars()) {
                    this.slistener.solutionFound();
                    this.modelFound();
                    return Lbool.TRUE;
                }
                if ((long)conflictC >= nofConflicts) {
                    this.cancelUntil(this.rootLevel);
                    return Lbool.UNDEFINED;
                }
                if (this.needToReduceDB) {
                    this.reduceDB();
                    this.needToReduceDB = false;
                }
                ++this.stats.decisions;
                int p = this.order.select();
                assert (p > 1);
                this.slistener.assuming(Solver.decode2dimacs(p));
                boolean ret = this.assume(p);
                assert (ret);
                continue;
            }
            ++this.stats.conflicts;
            ++conflictC;
            this.slistener.conflictFound();
            this.conflictCount.newConflict();
            if (this.decisionLevel() == this.rootLevel) {
                return Lbool.FALSE;
            }
            this.analyze(confl, this.analysisResult);
            assert (this.analysisResult.backtrackLevel < this.decisionLevel());
            this.cancelUntil(Math.max(this.analysisResult.backtrackLevel, this.rootLevel));
            assert (this.decisionLevel() >= this.rootLevel && this.decisionLevel() >= this.analysisResult.backtrackLevel);
            if (this.analysisResult.reason == null) {
                return Lbool.FALSE;
            }
            this.record(this.analysisResult.reason);
            this.analysisResult.reason = null;
            this.decayActivities();
        } while (this.undertimeout);
        return Lbool.UNDEFINED;
    }

    protected void analyzeAtRootLevel(Constr conflict) {
    }

    void modelFound() {
        this.model = new int[this.trail.size()];
        this.fullmodel = new boolean[this.nVars()];
        int index = 0;
        int i = 1;
        while (i <= this.voc.nVars()) {
            int p;
            if (this.voc.belongsToPool(i) && !this.voc.isUnassigned(p = this.voc.getFromPool(i))) {
                this.model[index++] = this.voc.isSatisfied(p) ? i : -i;
                this.fullmodel[i - 1] = this.voc.isSatisfied(p);
            }
            ++i;
        }
        assert (index == this.model.length);
        this.cancelUntil(this.rootLevel);
    }

    @Override
    public boolean model(int var) {
        if (var <= 0 || var > this.nVars()) {
            throw new IllegalArgumentException("Use a valid Dimacs var id as argument!");
        }
        if (this.fullmodel == null) {
            throw new UnsupportedOperationException("Call the solve method first!!!");
        }
        return this.fullmodel[var - 1];
    }

    protected void reduceDB() {
        this.reduceDB(this.claInc / (double)this.learnts.size());
    }

    @Override
    public void clearLearntClauses() {
        Iterator<Constr> iterator = this.learnts.iterator();
        while (iterator.hasNext()) {
            iterator.next().remove();
        }
        this.learnts.clear();
    }

    protected void reduceDB(double lim) {
        this.sortOnActivity();
        ++this.stats.reduceddb;
        int j = 0;
        int i = 0;
        while (i < this.learnts.size() / 2) {
            Constr c = this.learnts.get(i);
            if (c.locked()) {
                this.learnts.set(j++, this.learnts.get(i));
            } else {
                c.remove();
            }
            ++i;
        }
        while (i < this.learnts.size()) {
            this.learnts.set(j++, this.learnts.get(i));
            ++i;
        }
        System.out.println("c cleaning " + (this.learnts.size() - j) + " clauses out of " + this.learnts.size() + " for limit " + lim);
        this.learnts.shrinkTo(j);
    }

    private void sortOnActivity() {
        this.learnts.sort(this.comparator);
    }

    protected void decayActivities() {
        this.order.varDecayActivity();
        this.claDecayActivity();
    }

    private void claDecayActivity() {
        this.claInc *= this.claDecay;
    }

    @Override
    public boolean isSatisfiable() throws TimeoutException {
        return this.isSatisfiable(VecInt.EMPTY);
    }

    @Override
    public boolean isSatisfiable(boolean global) throws TimeoutException {
        return this.isSatisfiable(VecInt.EMPTY, global);
    }

    @Override
    public boolean isSatisfiable(IVecInt assumps) throws TimeoutException {
        return this.isSatisfiable(assumps, false);
    }

    @Override
    public boolean isSatisfiable(IVecInt assumps, boolean global) throws TimeoutException {
        Lbool status = Lbool.UNDEFINED;
        int howmany = this.voc.nVars();
        if (this.mseen.length < howmany) {
            this.mseen = new boolean[howmany + 1];
        }
        this.trail.ensure(howmany);
        this.trailLim.ensure(howmany);
        this.learnedLiterals = 0;
        this.order.init();
        this.learner.init();
        this.restarter.init(this.params);
        this.timebegin = System.currentTimeMillis();
        this.slistener.start();
        this.model = null;
        this.fullmodel = null;
        Constr confl = this.propagate();
        if (confl != null) {
            this.analyzeAtRootLevel(confl);
            this.slistener.end(Lbool.FALSE);
            this.cancelUntil(0);
            return false;
        }
        IteratorInt iterator = assumps.iterator();
        while (iterator.hasNext()) {
            if (this.assume(this.voc.getFromPool(iterator.next())) && this.propagate() == null) continue;
            this.slistener.end(Lbool.FALSE);
            this.cancelUntil(0);
            return false;
        }
        this.rootLevel = this.decisionLevel();
        final long memorybound = Runtime.getRuntime().freeMemory() / 10L;
        ConflictTimerAdapter freeMem = new ConflictTimerAdapter(500){
            private static final long serialVersionUID = 1L;

            @Override
            void run() {
                long freemem = Runtime.getRuntime().freeMemory();
                if (freemem < memorybound) {
                    Solver.this.needToReduceDB = true;
                }
            }
        };
        if (this.timeBasedTimeout) {
            if (!global || this.timer == null) {
                TimerTask stopMe = new TimerTask(){

                    @Override
                    public void run() {
                        Solver.this.undertimeout = false;
                    }
                };
                this.timer = new Timer(true);
                this.timer.schedule(stopMe, this.timeout);
                this.conflictCount = freeMem;
            }
        } else if (!global || this.conflictCount == null) {
            ConflictTimerAdapter conflictTimeout = new ConflictTimerAdapter((int)this.timeout){
                private static final long serialVersionUID = 1L;

                @Override
                public void run() {
                    Solver.this.undertimeout = false;
                }
            };
            this.conflictCount = new ConflictTimerContainer().add(conflictTimeout).add(freeMem);
        }
        this.needToReduceDB = false;
        this.undertimeout = true;
        while (status == Lbool.UNDEFINED && this.undertimeout) {
            status = this.search(this.restarter.nextRestartNumberOfConflict());
            this.restarter.onRestart();
        }
        this.cancelUntil(0);
        if (!global && this.timeBasedTimeout) {
            this.timer.cancel();
            this.timer = null;
        }
        this.slistener.end(status);
        if (!this.undertimeout) {
            throw new TimeoutException(" Timeout (" + this.timeout + "s) exceeded");
        }
        return status == Lbool.TRUE;
    }

    @Override
    public void printInfos(PrintWriter out, String prefix) {
        out.print(prefix);
        out.println("constraints type ");
        for (Map.Entry<String, Integer> entry : this.constrTypes.entrySet()) {
            out.println(String.valueOf(prefix) + entry.getKey() + " => " + entry.getValue());
        }
    }

    public SolverStats getStats() {
        return this.stats;
    }

    public IOrder<L> getOrder() {
        return this.order;
    }

    public void setOrder(IOrder<L> h) {
        this.order = h;
        this.order.setLits(this.voc);
    }

    public L getVocabulary() {
        return this.voc;
    }

    @Override
    public void reset() {
        this.voc.resetPool();
        this.dsfactory.reset();
        this.constrs.clear();
        this.learnts.clear();
        this.stats.reset();
        this.constrTypes.clear();
    }

    @Override
    public int nVars() {
        return this.voc.nVars();
    }

    protected IConstr addConstr(Constr constr) {
        if (constr != null) {
            this.constrs.push(constr);
            String type = constr.getClass().getName();
            Integer count = this.constrTypes.get(type);
            if (count == null) {
                this.constrTypes.put(type, 1);
            } else {
                this.constrTypes.put(type, count + 1);
            }
        }
        return constr;
    }

    public DataStructureFactory<L> getDSFactory() {
        return this.dsfactory;
    }

    public IVecInt getOutLearnt() {
        return this.outLearnt;
    }

    public IConstr getIthConstr(int i) {
        return this.constrs.get(i);
    }

    @Override
    public void printStat(PrintStream out, String prefix) {
        this.printStat(new PrintWriter(out), prefix);
    }

    @Override
    public void printStat(PrintWriter out, String prefix) {
        this.stats.printStat(out, prefix);
        double cputime = ((double)System.currentTimeMillis() - this.timebegin) / 1000.0;
        out.println(String.valueOf(prefix) + "speed (assignments/second)\t: " + (double)this.stats.propagations / cputime);
        this.order.printStat(out, prefix);
    }

    @Override
    public String toString(String prefix) {
        StringBuffer stb = new StringBuffer();
        Object[] objs = new Object[]{this.analyzer, this.dsfactory, this.learner, this.params, this.order, this.simplifier, this.restarter};
        stb.append(prefix);
        stb.append("--- Begin Solver configuration ---");
        stb.append("\n");
        Object[] objectArray = objs;
        int n = objs.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            stb.append(prefix);
            stb.append(o.toString());
            stb.append("\n");
            ++n2;
        }
        stb.append(prefix);
        stb.append("timeout=");
        if (this.timeBasedTimeout) {
            stb.append(this.timeout / 1000L);
            stb.append("s\n");
        } else {
            stb.append(this.timeout);
            stb.append(" conflicts\n");
        }
        stb.append(prefix);
        stb.append("DB Simplification allowed=");
        stb.append(this.isDBSimplificationAllowed);
        stb.append("\n");
        stb.append(prefix);
        stb.append("--- End Solver configuration ---");
        return stb.toString();
    }

    public String toString() {
        return this.toString("");
    }

    @Override
    public int getTimeout() {
        return (int)(this.timeBasedTimeout ? this.timeout / 1000L : this.timeout);
    }

    @Override
    public void setExpectedNumberOfClauses(int nb) {
        this.constrs.ensure(nb);
    }

    @Override
    public Map<String, Number> getStat() {
        return this.stats.toMap();
    }

    @Override
    public int[] findModel() throws TimeoutException {
        if (this.isSatisfiable()) {
            return this.model();
        }
        return null;
    }

    @Override
    public int[] findModel(IVecInt assumps) throws TimeoutException {
        if (this.isSatisfiable(assumps)) {
            return this.model();
        }
        return null;
    }

    @Override
    public boolean isDBSimplificationAllowed() {
        return this.isDBSimplificationAllowed;
    }

    @Override
    public void setDBSimplificationAllowed(boolean status) {
        this.isDBSimplificationAllowed = status;
    }

    static interface ISimplifier
    extends Serializable {
        public void simplify(IVecInt var1);
    }
}

