/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.core;

import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

public class SolverStats
implements Serializable {
    private static final long serialVersionUID = 1L;
    public int starts;
    public long decisions;
    public long propagations;
    public long inspects;
    public long conflicts;
    public long learnedliterals;
    public long learnedbinaryclauses;
    public long learnedternaryclauses;
    public long learnedclauses;
    public long ignoredclauses;
    public long rootSimplifications;
    public long reducedliterals;
    public long changedreason;
    public int reduceddb;

    public void reset() {
        this.starts = 0;
        this.decisions = 0L;
        this.propagations = 0L;
        this.inspects = 0L;
        this.conflicts = 0L;
        this.learnedliterals = 0L;
        this.learnedclauses = 0L;
        this.ignoredclauses = 0L;
        this.learnedbinaryclauses = 0L;
        this.learnedternaryclauses = 0L;
        this.rootSimplifications = 0L;
        this.reducedliterals = 0L;
        this.changedreason = 0L;
        this.reduceddb = 0;
    }

    public void printStat(PrintWriter out, String prefix) {
        out.println(String.valueOf(prefix) + "starts\t\t: " + this.starts);
        out.println(String.valueOf(prefix) + "conflicts\t\t: " + this.conflicts);
        out.println(String.valueOf(prefix) + "decisions\t\t: " + this.decisions);
        out.println(String.valueOf(prefix) + "propagations\t\t: " + this.propagations);
        out.println(String.valueOf(prefix) + "inspects\t\t: " + this.inspects);
        out.println(String.valueOf(prefix) + "learnt literals\t: " + this.learnedliterals);
        out.println(String.valueOf(prefix) + "learnt binary clauses\t: " + this.learnedbinaryclauses);
        out.println(String.valueOf(prefix) + "learnt ternary clauses\t: " + this.learnedternaryclauses);
        out.println(String.valueOf(prefix) + "learnt clauses\t: " + this.learnedclauses);
        out.println(String.valueOf(prefix) + "ignored clauses\t: " + this.ignoredclauses);
        out.println(String.valueOf(prefix) + "root simplifications\t: " + this.rootSimplifications);
        out.println(String.valueOf(prefix) + "removed literals (reason simplification)\t: " + this.reducedliterals);
        out.println(String.valueOf(prefix) + "reason swapping (by a shorter reason)\t: " + this.changedreason);
        out.println(String.valueOf(prefix) + "Calls to reduceDB\t: " + this.reduceddb);
    }

    public Map<String, Number> toMap() {
        HashMap<String, Number> map = new HashMap<String, Number>();
        Field[] fieldArray = this.getClass().getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            try {
                map.put(f.getName(), (Number)f.get(this));
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            ++n2;
        }
        return map;
    }
}

