/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.learning;

import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.DataStructureFactory;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.IOrder;
import org.sat4j.minisat.core.Solver;
import org.sat4j.minisat.learning.LimitedLearning;

public class ActiveLearning<L extends ILits, D extends DataStructureFactory<L>>
extends LimitedLearning<L, D> {
    private static final long serialVersionUID = 1L;
    private double percent;
    private IOrder<L> order;
    private int maxpercent;

    public ActiveLearning() {
        this(0.95);
    }

    public ActiveLearning(double d) {
        this.percent = d;
    }

    public void setOrder(IOrder<L> order) {
        this.order = order;
    }

    @Override
    public void setSolver(Solver<L, D> s) {
        super.setSolver(s);
        this.order = s.getOrder();
    }

    public void setActivityPercent(double d) {
        this.percent = d;
    }

    public double getActivityPercent() {
        return this.percent;
    }

    @Override
    protected boolean learningCondition(Constr clause) {
        int nbactivevars = 0;
        int i = 0;
        while (i < clause.size()) {
            if (this.order.varActivity(clause.get(i)) > 1.0) {
                ++nbactivevars;
            }
            ++i;
        }
        return (double)nbactivevars > (double)clause.size() * this.percent;
    }

    public String toString() {
        return "Limit learning to clauses containing active literals (" + this.percent * 100.0 + "%)";
    }

    public void setLimit(int percent) {
        this.maxpercent = percent;
    }

    public int getLimit() {
        return this.maxpercent;
    }
}

