/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.learning;

import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.DataStructureFactory;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.LearningStrategy;
import org.sat4j.minisat.core.Solver;
import org.sat4j.minisat.core.SolverStats;
import org.sat4j.minisat.core.VarActivityListener;
import org.sat4j.minisat.learning.MiniSATLearning;
import org.sat4j.minisat.learning.NoLearningButHeuristics;

public abstract class LimitedLearning<L extends ILits, D extends DataStructureFactory<L>>
implements LearningStrategy<L, D> {
    private static final long serialVersionUID = 1L;
    private final NoLearningButHeuristics<L, D> none = new NoLearningButHeuristics();
    private final MiniSATLearning<L, D> all = new MiniSATLearning();
    protected L lits;
    private SolverStats stats;

    @Override
    public void setSolver(Solver<L, D> s) {
        this.lits = s.getVocabulary();
        this.setVarActivityListener(s);
        this.all.setDataStructureFactory(s.getDSFactory());
        this.stats = s.getStats();
    }

    @Override
    public void learns(Constr constr) {
        if (this.learningCondition(constr)) {
            this.all.learns(constr);
        } else {
            this.none.learns(constr);
            ++this.stats.ignoredclauses;
        }
    }

    protected abstract boolean learningCondition(Constr var1);

    @Override
    public void init() {
        this.all.init();
        this.none.init();
    }

    @Override
    public void setVarActivityListener(VarActivityListener s) {
        this.none.setVarActivityListener(s);
        this.all.setVarActivityListener(s);
    }
}

