/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.learning;

import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.DataStructureFactory;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.Solver;
import org.sat4j.minisat.learning.AbstractLearning;

public class MiniSATLearning<L extends ILits, D extends DataStructureFactory<L>>
extends AbstractLearning<L, D> {
    private static final long serialVersionUID = 1L;
    private DataStructureFactory<L> dsf;

    public void setDataStructureFactory(DataStructureFactory<L> dsf) {
        this.dsf = dsf;
    }

    @Override
    public void setSolver(Solver<L, D> s) {
        super.setSolver(s);
        this.dsf = s.getDSFactory();
    }

    @Override
    public void learns(Constr constr) {
        this.claBumpActivity(constr);
        this.dsf.learnConstraint(constr);
    }

    public String toString() {
        return "Learn all clauses as in MiniSAT";
    }
}

