/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.orders;

import java.util.ArrayList;
import java.util.Collections;
import org.sat4j.core.LiteralsUtils;
import org.sat4j.minisat.core.ILits23;
import org.sat4j.minisat.orders.ValuedLit;
import org.sat4j.minisat.orders.VarOrder;

public class JWOrder
extends VarOrder<ILits23> {
    private static final long serialVersionUID = 1L;

    private int computeWeight(int var) {
        int p = LiteralsUtils.posLit(var);
        int pos2 = ((ILits23)this.lits).nBinaryClauses(p);
        int neg2 = ((ILits23)this.lits).nBinaryClauses(LiteralsUtils.neg(p));
        int pos3 = ((ILits23)this.lits).nTernaryClauses(p);
        int neg3 = ((ILits23)this.lits).nTernaryClauses(LiteralsUtils.neg(p));
        long weight = ((long)(pos2 * neg2) * 100L + (long)pos2 + (long)neg2) * 5L + (long)(pos3 * neg3) * 10L + (long)pos3 + (long)neg3;
        assert (weight <= Integer.MAX_VALUE);
        if (weight == 0L) {
            int pos = ((ILits23)this.lits).watches(p).size();
            int neg = ((ILits23)this.lits).watches(LiteralsUtils.neg(p)).size();
            weight = pos + neg;
        }
        return (int)weight;
    }

    @Override
    public void init() {
        ValuedLit t;
        super.init();
        ArrayList<ValuedLit> v = new ArrayList<ValuedLit>(this.order.length);
        int i = 1;
        while (i < this.order.length) {
            t = new ValuedLit(this.order[i], this.computeWeight(this.order[i] >> 1));
            v.add(t);
            ++i;
        }
        Collections.sort(v);
        i = 0;
        while (i < v.size()) {
            t = (ValuedLit)v.get(i);
            this.order[i + 1] = t.id;
            int index = LiteralsUtils.var(t.id);
            this.varpos[index] = i + 1;
            this.activity[index] = t.count;
            ++i;
        }
        this.lastVar = 1;
    }

    @Override
    protected void updateActivity(int var) {
        this.activity[var] = this.computeWeight(var);
    }

    @Override
    public String toString() {
        return "Jeroslow-Wang static like heuristics updated when new clauses are learnt";
    }
}

