/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.orders;

import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.orders.VarOrder;

public class PureOrder
extends VarOrder<ILits> {
    private static final long serialVersionUID = 1L;
    private int period;
    private int cpt;

    public PureOrder() {
        this(20);
    }

    public PureOrder(int p) {
        this.setPeriod(p);
    }

    public final void setPeriod(int p) {
        this.cpt = this.period = p;
    }

    public int getPeriod() {
        return this.period;
    }

    @Override
    public int select() {
        if (this.cpt < this.period) {
            ++this.cpt;
        } else {
            this.cpt = 0;
            int nblits = 2 * this.lits.nVars();
            int i = 2;
            while (i <= nblits) {
                if (this.lits.isUnassigned(i) && this.lits.watches(i).size() > 0 && this.lits.watches(i ^ 1).size() == 0) {
                    return i;
                }
                ++i;
            }
        }
        return super.select();
    }

    @Override
    public String toString() {
        return "tries to first branch on a single phase watched unassigned variable (pure literal if using a CB data structure) else VSIDS from MiniSAT";
    }
}

