/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.orders;

import java.io.PrintWriter;
import java.io.Serializable;
import org.sat4j.core.LiteralsUtils;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.IOrder;
import org.sat4j.minisat.core.IPhaseSelectionStrategy;
import org.sat4j.minisat.orders.PhaseInLastLearnedClauseSelectionStrategy;

public class VarOrder<L extends ILits>
implements Serializable,
IOrder<L> {
    private static final long serialVersionUID = 1L;
    private static final double VAR_RESCALE_FACTOR = 1.0E-100;
    private static final double VAR_RESCALE_BOUND = 1.0E100;
    protected double[] activity = new double[1];
    protected int lastVar = 1;
    protected int[] order = new int[1];
    private double varDecay = 1.0;
    private double varInc = 1.0;
    protected int[] varpos = new int[1];
    protected L lits;
    private long nullchoice = 0L;
    protected IPhaseSelectionStrategy phaseStrategy;

    public VarOrder() {
        this(new PhaseInLastLearnedClauseSelectionStrategy());
    }

    public VarOrder(IPhaseSelectionStrategy strategy) {
        this.phaseStrategy = strategy;
    }

    @Override
    public void setPhaseSelectionStrategy(IPhaseSelectionStrategy strategy) {
        this.phaseStrategy = strategy;
    }

    @Override
    public IPhaseSelectionStrategy getPhaseSelectionStrategy() {
        return this.phaseStrategy;
    }

    @Override
    public void setLits(L lits) {
        this.lits = lits;
    }

    @Override
    public int select() {
        assert (this.lastVar > 0);
        int i = this.lastVar;
        while (i < this.order.length) {
            assert (i > 0);
            if (this.lits.isUnassigned(this.order[i])) {
                this.lastVar = i;
                if (this.activity[i] < 1.0E-4) {
                    ++this.nullchoice;
                }
                return this.order[i];
            }
            ++i;
        }
        return -1;
    }

    @Override
    public void setVarDecay(double d) {
        this.varDecay = d;
    }

    @Override
    public void undo(int x) {
        assert (x > 0);
        assert (x < this.order.length);
        int pos = this.varpos[x];
        if (pos < this.lastVar) {
            this.lastVar = pos;
        }
        assert (this.lastVar > 0);
    }

    @Override
    public void updateVar(int p) {
        assert (p > 1);
        int var = LiteralsUtils.var(p);
        this.updateActivity(var);
        int i = this.varpos[var];
        while (i > 1 && this.activity[LiteralsUtils.var(this.order[i - 1])] < this.activity[var]) {
            assert (i > 1);
            int orderpm1 = this.order[i - 1];
            assert (this.varpos[LiteralsUtils.var(orderpm1)] == i - 1);
            this.varpos[LiteralsUtils.var((int)orderpm1)] = i;
            this.order[i] = orderpm1;
            --i;
        }
        assert (i >= 1);
        this.varpos[var] = i;
        this.order[i] = p;
        if (i < this.lastVar) {
            this.lastVar = i;
        }
    }

    protected void updateActivity(int var) {
        int n = var;
        double d = this.activity[n] = this.activity[n] + this.varInc;
        if (d > 1.0E100) {
            this.varRescaleActivity();
        }
    }

    @Override
    public void varDecayActivity() {
        this.varInc *= this.varDecay;
    }

    private void varRescaleActivity() {
        int i = 1;
        while (i < this.activity.length) {
            int n = i++;
            this.activity[n] = this.activity[n] * 1.0E-100;
        }
        this.varInc *= 1.0E-100;
    }

    @Override
    public double varActivity(int p) {
        return this.activity[LiteralsUtils.var(p)];
    }

    public int numberOfInterestingVariables() {
        int cpt = 0;
        int i = 1;
        while (i < this.activity.length) {
            if (this.activity[i] > 1.0) {
                ++cpt;
            }
            ++i;
        }
        return cpt;
    }

    @Override
    public void init() {
        int nlength = this.lits.nVars() + 1;
        int reallength = this.lits.realnVars() + 1;
        int[] nvarpos = new int[nlength];
        double[] nactivity = new double[nlength];
        int[] norder = new int[reallength];
        nvarpos[0] = -1;
        nactivity[0] = -1.0;
        norder[0] = -1;
        int i = 1;
        int j = 1;
        while (i < nlength) {
            assert (i > 0);
            assert (i <= this.lits.nVars()) : this.lits.nVars() + "/" + i;
            if (this.lits.belongsToPool(i)) {
                norder[j] = LiteralsUtils.neg(this.lits.getFromPool(i));
                nvarpos[i] = j++;
            }
            nactivity[i] = 0.0;
            ++i;
        }
        this.varpos = nvarpos;
        this.activity = nactivity;
        this.order = norder;
        this.lastVar = 1;
    }

    public String toString() {
        return "VSIDS like heuristics from MiniSAT using a sorted array";
    }

    public ILits getVocabulary() {
        return this.lits;
    }

    @Override
    public void printStat(PrintWriter out, String prefix) {
        out.println(String.valueOf(prefix) + "non guided choices\t" + this.nullchoice);
    }

    @Override
    public void assignLiteral(int p) {
    }
}

