/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.restarts;

import org.sat4j.minisat.core.RestartStrategy;
import org.sat4j.minisat.core.SearchParams;

public class ArminRestarts
implements RestartStrategy {
    private static final long serialVersionUID = 1L;
    private double inner;
    private double outer;
    private long conflicts;
    private SearchParams params;

    @Override
    public void init(SearchParams params) {
        this.params = params;
        this.inner = params.getInitConflictBound();
        this.outer = params.getInitConflictBound();
        this.conflicts = Math.round(this.inner);
    }

    @Override
    public long nextRestartNumberOfConflict() {
        return this.conflicts;
    }

    @Override
    public void onRestart() {
        if (this.inner >= this.outer) {
            this.outer *= this.params.getConflictBoundIncFactor();
            this.inner = this.params.getInitConflictBound();
        } else {
            this.inner *= this.params.getConflictBoundIncFactor();
        }
        this.conflicts = Math.round(this.inner);
    }

    public String toString() {
        return "Armin Biere (Picosat) restarts strategy";
    }
}

