/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.restarts;

import org.sat4j.minisat.core.RestartStrategy;
import org.sat4j.minisat.core.SearchParams;

public class LubyRestarts
implements RestartStrategy {
    private static final long serialVersionUID = 1L;
    private static int[] cachedValues = new int[]{1, 1, 2};
    private int factor;
    private int count;

    static {
        LubyRestarts.luby(32);
    }

    public static final int luby(int i) {
        if (i >= 0x3FFFFFFF) {
            throw new IllegalArgumentException("i is too big");
        }
        if (i >= cachedValues.length) {
            int oldsize = cachedValues.length;
            int newsize = i << 1;
            int[] newContent = new int[newsize + 1];
            System.arraycopy(cachedValues, 0, newContent, 0, oldsize);
            int nextPowerOfTwo = 1;
            while (nextPowerOfTwo <= oldsize) {
                nextPowerOfTwo <<= 1;
            }
            int lastPowerOfTwo = nextPowerOfTwo >> 1;
            int j = oldsize;
            while (j <= newsize) {
                if (j + 1 == nextPowerOfTwo) {
                    newContent[j] = lastPowerOfTwo;
                    lastPowerOfTwo = nextPowerOfTwo;
                    nextPowerOfTwo <<= 1;
                } else {
                    newContent[j] = newContent[j - lastPowerOfTwo + 1];
                }
                ++j;
            }
            cachedValues = newContent;
        }
        return cachedValues[i];
    }

    public LubyRestarts() {
        this.setFactor(32);
    }

    public void setFactor(int factor) {
        this.factor = factor;
    }

    public int getFactor() {
        return this.factor;
    }

    @Override
    public void init(SearchParams params) {
        this.count = 1;
    }

    @Override
    public long nextRestartNumberOfConflict() {
        return LubyRestarts.luby(this.count) * this.factor;
    }

    @Override
    public void onRestart() {
        ++this.count;
    }

    public String toString() {
        return "luby style (SATZ_rand, TiniSAT) restarts strategy with factor " + this.factor;
    }
}

