/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.opt;

import org.sat4j.core.VecInt;
import org.sat4j.opt.AbstractSelectorVariablesDecorator;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.IOptimizationProblem;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;

public class MaxSatDecorator
extends AbstractSelectorVariablesDecorator
implements IOptimizationProblem {
    private static final long serialVersionUID = 1L;
    private final IVecInt lits = new VecInt();
    private int counter;

    public MaxSatDecorator(ISolver solver) {
        super(solver);
    }

    @Override
    public void setExpectedNumberOfClauses(int nb) {
        super.setExpectedNumberOfClauses(nb);
        this.lits.ensure(nb);
    }

    @Override
    public IConstr addClause(IVecInt literals) throws ContradictionException {
        int newvar = this.nborigvars + ++this.nbnewvar;
        this.lits.push(newvar);
        literals.push(newvar);
        return super.addClause(literals);
    }

    @Override
    public void reset() {
        this.nbnewvar = 0;
        this.lits.clear();
        super.reset();
    }

    @Override
    public boolean hasNoObjectiveFunction() {
        return false;
    }

    @Override
    public boolean nonOptimalMeansSatisfiable() {
        return false;
    }

    @Override
    public Number calculateObjective() {
        this.counter = 0;
        int[] nArray = this.prevfullmodel;
        int n = this.prevfullmodel.length;
        int n2 = 0;
        while (n2 < n) {
            int q = nArray[n2];
            if (q > this.nborigvars) {
                ++this.counter;
            }
            ++n2;
        }
        return this.counter;
    }

    @Override
    public void discard() throws ContradictionException {
        super.addAtMost(this.lits, this.counter - 1);
    }
}

