/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.opt;

import org.sat4j.core.VecInt;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IOptimizationProblem;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.TimeoutException;
import org.sat4j.tools.SolverDecorator;

public class MinOneDecorator
extends SolverDecorator<ISolver>
implements IOptimizationProblem {
    private static final long serialVersionUID = 1L;
    private int[] prevmodel;
    private int counter;
    private final IVecInt literals = new VecInt();

    public MinOneDecorator(ISolver solver) {
        super(solver);
    }

    @Override
    public boolean admitABetterSolution() throws TimeoutException {
        boolean result = this.isSatisfiable(true);
        if (result) {
            this.prevmodel = super.model();
        }
        return result;
    }

    @Override
    public boolean hasNoObjectiveFunction() {
        return false;
    }

    @Override
    public boolean nonOptimalMeansSatisfiable() {
        return true;
    }

    @Override
    public Number calculateObjective() {
        this.counter = 0;
        int[] nArray = this.prevmodel;
        int n = this.prevmodel.length;
        int n2 = 0;
        while (n2 < n) {
            int p = nArray[n2];
            if (p > 0) {
                ++this.counter;
            }
            ++n2;
        }
        return new Integer(this.counter);
    }

    @Override
    public void discard() throws ContradictionException {
        if (this.literals.isEmpty()) {
            int i = 1;
            while (i <= this.nVars()) {
                this.literals.push(i);
                ++i;
            }
        }
        this.addAtMost(this.literals, this.counter - 1);
    }

    @Override
    public int[] model() {
        return this.prevmodel;
    }

    @Override
    public void reset() {
        this.literals.clear();
        super.reset();
    }
}

