/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.reader;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Scanner;
import org.sat4j.core.VecInt;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.reader.Reader;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IProblem;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;
import org.sat4j.tools.GateTranslator;

public class AAGReader
extends Reader {
    private static final int FALSE = 0;
    private static final int TRUE = 1;
    private final GateTranslator solver;
    private int maxvarid;
    private int nbinputs;

    AAGReader(ISolver s) {
        this.solver = new GateTranslator(s);
    }

    @Override
    public String decode(int[] model) {
        StringBuffer stb = new StringBuffer();
        int i = 0;
        while (i < this.nbinputs) {
            stb.append(model[i] > 0 ? 1 : 0);
            ++i;
        }
        return stb.toString();
    }

    @Override
    public void decode(int[] model, PrintWriter out) {
        int i = 0;
        while (i < this.nbinputs) {
            out.print(model[i] > 0 ? 1 : 0);
            ++i;
        }
    }

    @Override
    public IProblem parseInstance(java.io.Reader in) throws ParseFormatException, ContradictionException, IOException {
        Scanner scanner = new Scanner(in);
        String prefix = scanner.next();
        if (!"aag".equals(prefix)) {
            throw new ParseFormatException("AAG format only!");
        }
        this.maxvarid = scanner.nextInt();
        this.nbinputs = scanner.nextInt();
        int nblatches = scanner.nextInt();
        int nboutputs = scanner.nextInt();
        if (nboutputs > 1) {
            throw new ParseFormatException("CNF conversion allowed for single output circuit only!");
        }
        int nbands = scanner.nextInt();
        this.solver.newVar(this.maxvarid + 1);
        this.solver.setExpectedNumberOfClauses(3 * nbands + 2);
        this.readInput(this.nbinputs, scanner);
        assert (nblatches == 0);
        if (nboutputs > 0) {
            int output0 = this.readOutput(nboutputs, scanner);
            this.readAnd(nbands, output0, scanner);
        }
        return this.solver;
    }

    private void readAnd(int nbands, int output0, Scanner scanner) throws ContradictionException {
        int i = 0;
        while (i < nbands) {
            int lhs = scanner.nextInt();
            int rhs0 = scanner.nextInt();
            int rhs1 = scanner.nextInt();
            this.solver.and(this.toDimacs(lhs), this.toDimacs(rhs0), this.toDimacs(rhs1));
            ++i;
        }
        this.solver.gateTrue(this.maxvarid + 1);
        this.solver.gateTrue(this.toDimacs(output0));
    }

    private int toDimacs(int v) {
        if (v == 0) {
            return -(this.maxvarid + 1);
        }
        if (v == 1) {
            return this.maxvarid + 1;
        }
        int var = v >> 1;
        if ((v & 1) == 0) {
            return var;
        }
        return -var;
    }

    private int readOutput(int nboutputs, Scanner scanner) {
        VecInt outputs = new VecInt(nboutputs);
        int i = 0;
        while (i < nboutputs) {
            outputs.push(scanner.nextInt());
            ++i;
        }
        return outputs.get(0);
    }

    private IVecInt readInput(int nbinputs, Scanner scanner) {
        VecInt inputs = new VecInt(nbinputs);
        int i = 0;
        while (i < nbinputs) {
            inputs.push(scanner.nextInt());
            ++i;
        }
        return inputs;
    }
}

