/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.reader;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Scanner;
import java.util.StringTokenizer;
import org.sat4j.core.VecInt;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.reader.Reader;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IProblem;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;

public class DimacsReader
extends Reader
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected int expectedNbOfConstr;
    protected final ISolver solver;
    private boolean checkConstrNb = true;
    protected final String formatString;

    public DimacsReader(ISolver solver) {
        this(solver, "cnf");
    }

    public DimacsReader(ISolver solver, String format) {
        this.solver = solver;
        this.formatString = format;
    }

    public void disableNumberOfConstraintCheck() {
        this.checkConstrNb = false;
    }

    protected void skipComments(LineNumberReader in) throws IOException {
        int c;
        do {
            in.mark(4);
            c = in.read();
            if (c == 99) {
                in.readLine();
                continue;
            }
            in.reset();
        } while (c == 99);
    }

    protected void readProblemLine(LineNumberReader in) throws IOException, ParseFormatException {
        String line = in.readLine();
        if (line == null) {
            throw new ParseFormatException("premature end of file: <p cnf ...> expected  on line " + in.getLineNumber());
        }
        StringTokenizer stk = new StringTokenizer(line);
        if (!(stk.hasMoreTokens() && stk.nextToken().equals("p") && stk.hasMoreTokens() && stk.nextToken().equals(this.formatString))) {
            throw new ParseFormatException("problem line expected (p cnf ...) on line " + in.getLineNumber());
        }
        int vars = Integer.parseInt(stk.nextToken());
        assert (vars > 0);
        this.solver.newVar(vars);
        this.expectedNbOfConstr = Integer.parseInt(stk.nextToken());
        assert (this.expectedNbOfConstr > 0);
        this.solver.setExpectedNumberOfClauses(this.expectedNbOfConstr);
    }

    protected void readConstrs(LineNumberReader in) throws IOException, ParseFormatException, ContradictionException {
        int realNbOfConstr = 0;
        VecInt literals = new VecInt();
        while (true) {
            String line;
            if ((line = in.readLine()) == null) {
                if (literals.size() <= 0) break;
                this.solver.addClause(literals);
                ++realNbOfConstr;
                break;
            }
            if (line.startsWith("c ")) continue;
            if (line.startsWith("%") && this.expectedNbOfConstr == realNbOfConstr) {
                System.out.println("Ignoring the rest of the file (SATLIB format");
                break;
            }
            boolean added = this.handleConstr(line, literals);
            if (!added) continue;
            ++realNbOfConstr;
        }
        if (this.checkConstrNb && this.expectedNbOfConstr != realNbOfConstr) {
            throw new ParseFormatException("wrong nbclauses parameter. Found " + realNbOfConstr + ", " + this.expectedNbOfConstr + " expected");
        }
    }

    protected boolean handleConstr(String line, IVecInt literals) throws ContradictionException {
        boolean added = false;
        Scanner scan = new Scanner(line);
        while (scan.hasNext()) {
            int lit = scan.nextInt();
            if (lit == 0) {
                if (literals.size() <= 0) continue;
                this.solver.addClause(literals);
                literals.clear();
                added = true;
                continue;
            }
            literals.push(lit);
        }
        return added;
    }

    @Override
    public final IProblem parseInstance(java.io.Reader in) throws ParseFormatException, ContradictionException, IOException {
        return this.parseInstance(new LineNumberReader(in));
    }

    private IProblem parseInstance(LineNumberReader in) throws ParseFormatException, ContradictionException {
        this.solver.reset();
        try {
            this.skipComments(in);
            this.readProblemLine(in);
            this.readConstrs(in);
            return this.solver;
        }
        catch (IOException e) {
            throw new ParseFormatException(e);
        }
        catch (NumberFormatException e) {
            throw new ParseFormatException("integer value expected on line " + in.getLineNumber(), e);
        }
    }

    @Override
    public String decode(int[] model) {
        StringBuffer stb = new StringBuffer();
        int i = 0;
        while (i < model.length) {
            stb.append(model[i]);
            stb.append(" ");
            ++i;
        }
        stb.append("0");
        return stb.toString();
    }

    @Override
    public void decode(int[] model, PrintWriter out) {
        int i = 0;
        while (i < model.length) {
            out.print(model[i]);
            out.print(" ");
            ++i;
        }
        out.print("0");
    }

    protected ISolver getSolver() {
        return this.solver;
    }
}

