/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.reader;

import java.io.IOException;
import java.io.LineNumberReader;
import java.util.Scanner;
import java.util.StringTokenizer;
import org.sat4j.reader.DimacsReader;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;
import org.sat4j.tools.GateTranslator;

public class ExtendedDimacsReader
extends DimacsReader {
    public static final int FALSE = 1;
    public static final int TRUE = 2;
    public static final int NOT = 3;
    public static final int AND = 4;
    public static final int NAND = 5;
    public static final int OR = 6;
    public static final int NOR = 7;
    public static final int XOR = 8;
    public static final int XNOR = 9;
    public static final int IMPLIES = 10;
    public static final int IFF = 11;
    public static final int IFTHENELSE = 12;
    public static final int ATLEAST = 13;
    public static final int ATMOST = 14;
    public static final int COUNT = 15;
    private static final long serialVersionUID = 1L;

    public ExtendedDimacsReader(ISolver solver) {
        super(new GateTranslator(solver));
    }

    @Override
    protected void readProblemLine(LineNumberReader in) throws IOException, ParseFormatException {
        String line = in.readLine();
        if (line == null) {
            throw new ParseFormatException("premature end of file: <p noncnf ...> expected  on line " + in.getLineNumber());
        }
        StringTokenizer stk = new StringTokenizer(line);
        if (!(stk.hasMoreTokens() && stk.nextToken().equals("p") && stk.hasMoreTokens() && stk.nextToken().equals("noncnf"))) {
            throw new ParseFormatException("problem line expected (p noncnf ...) on line " + in.getLineNumber());
        }
        int vars = Integer.parseInt(stk.nextToken());
        assert (vars > 0);
        this.solver.newVar(vars);
        try {
            ((GateTranslator)this.solver).gateTrue(vars);
        }
        catch (ContradictionException e) {
            assert (false);
            System.err.println("Contradiction when asserting root variable?");
        }
        this.disableNumberOfConstraintCheck();
    }

    @Override
    protected boolean handleConstr(String line, IVecInt literals) throws ContradictionException {
        boolean added = true;
        assert (literals.size() == 0);
        Scanner scan = new Scanner(line);
        GateTranslator gater = (GateTranslator)this.solver;
        while (scan.hasNext()) {
            int x;
            int gateType = scan.nextInt();
            assert (gateType > 0);
            int nbparam = scan.nextInt();
            assert (nbparam != 0);
            assert (nbparam == -1 || gateType >= 13);
            int i = 0;
            while (i < nbparam) {
                scan.nextInt();
                ++i;
            }
            int y = scan.nextInt();
            while ((x = scan.nextInt()) != 0) {
                literals.push(x);
            }
            switch (gateType) {
                case 1: {
                    assert (literals.size() == 0);
                    gater.gateFalse(y);
                    break;
                }
                case 2: {
                    assert (literals.size() == 0);
                    gater.gateTrue(y);
                    break;
                }
                case 6: {
                    gater.or(y, literals);
                    break;
                }
                case 3: {
                    assert (literals.size() == 1);
                    gater.not(y, literals.get(0));
                    break;
                }
                case 4: {
                    gater.and(y, literals);
                    break;
                }
                case 8: {
                    gater.xor(y, literals);
                    break;
                }
                case 11: {
                    gater.iff(y, literals);
                    break;
                }
                case 12: {
                    assert (literals.size() == 3);
                    gater.ite(y, literals.get(0), literals.get(1), literals.get(2));
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Gate type " + gateType + " not handled yet");
                }
            }
        }
        literals.clear();
        return added;
    }
}

