/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.reader;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Locale;
import org.sat4j.reader.AAGReader;
import org.sat4j.reader.AIGReader;
import org.sat4j.reader.DimacsReader;
import org.sat4j.reader.ExtendedDimacsReader;
import org.sat4j.reader.LecteurDimacs;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.reader.Reader;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IProblem;
import org.sat4j.specs.ISolver;

public class InstanceReader
extends Reader {
    private AAGReader aag;
    private AIGReader aig;
    private DimacsReader ezdimacs;
    private LecteurDimacs dimacs;
    private ExtendedDimacsReader edimacs;
    private Reader reader = null;
    private final ISolver solver;

    public InstanceReader(ISolver solver) {
        this.solver = solver;
    }

    private Reader getDefaultSATReader() {
        if (this.dimacs == null) {
            this.dimacs = new LecteurDimacs(this.solver);
        }
        return this.dimacs;
    }

    private Reader getEZSATReader() {
        if (this.ezdimacs == null) {
            this.ezdimacs = new DimacsReader(this.solver);
        }
        return this.ezdimacs;
    }

    private Reader getDefaultExtendedDimacsReader() {
        if (this.edimacs == null) {
            this.edimacs = new ExtendedDimacsReader(this.solver);
        }
        return this.edimacs;
    }

    private Reader getAIGReader() {
        if (this.aig == null) {
            this.aig = new AIGReader(this.solver);
        }
        return this.aig;
    }

    private Reader getAAGReader() {
        if (this.aag == null) {
            this.aag = new AAGReader(this.solver);
        }
        return this.aag;
    }

    @Override
    public IProblem parseInstance(String filename) throws FileNotFoundException, ParseFormatException, IOException, ContradictionException {
        boolean isHttp = false;
        String tempFileName = "";
        String prefix = "";
        if (filename.startsWith("http://")) {
            isHttp = true;
            tempFileName = filename;
            filename = filename.substring(filename.lastIndexOf(47), filename.length() - 1);
        }
        if (filename.indexOf(58) != -1) {
            String[] parts = filename.split(":");
            filename = parts[1];
            prefix = parts[0].toUpperCase(Locale.getDefault());
        }
        String fname = filename.endsWith(".gz") ? filename.substring(0, filename.lastIndexOf(46)) : filename;
        this.reader = "EZCNF".equals(prefix) ? this.getEZSATReader() : (fname.endsWith(".edimacs") || fname.endsWith(".ncnf") || "EDIMACS".equals(prefix) ? this.getDefaultExtendedDimacsReader() : (fname.endsWith(".aag") ? this.getAAGReader() : (fname.endsWith(".aig") ? this.getAIGReader() : this.getDefaultSATReader())));
        if (isHttp) {
            return this.reader.parseInstance(new URL(tempFileName).openStream());
        }
        return this.reader.parseInstance(filename);
    }

    @Override
    @Deprecated
    public String decode(int[] model) {
        return this.reader.decode(model);
    }

    @Override
    public void decode(int[] model, PrintWriter out) {
        this.reader.decode(model, out);
    }

    @Override
    public IProblem parseInstance(java.io.Reader in) throws ParseFormatException, ContradictionException, IOException {
        throw new UnsupportedOperationException();
    }
}

