/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.reader;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import org.sat4j.core.VecInt;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.reader.Reader;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IProblem;
import org.sat4j.specs.ISolver;

public class LecteurDimacs
extends Reader
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int TAILLE_BUF = 16384;
    private final ISolver s;
    private transient BufferedInputStream in;
    private int nbVars = -1;
    private int nbClauses = -1;
    private static final char EOF = '\uffff';

    public LecteurDimacs(ISolver s) {
        this.s = s;
    }

    @Override
    public final IProblem parseInstance(InputStream in) throws ParseFormatException, ContradictionException, IOException {
        this.in = new BufferedInputStream(in, 16384);
        this.s.reset();
        this.passerCommentaire();
        if (this.nbVars < 0) {
            throw new ParseFormatException("DIMACS error: wrong max number of variables");
        }
        this.s.newVar(this.nbVars);
        this.s.setExpectedNumberOfClauses(this.nbClauses);
        char car = this.passerEspaces();
        if (this.nbClauses > 0) {
            if (car == '\uffff') {
                throw new ParseFormatException("DIMACS error: the clauses are missing");
            }
            this.ajouterClauses(car);
        }
        in.close();
        return this.s;
    }

    @Override
    public IProblem parseInstance(java.io.Reader in) throws IOException, ContradictionException {
        throw new UnsupportedOperationException();
    }

    private char passerCommentaire() throws IOException {
        char car;
        do {
            if ((car = this.passerEspaces()) != 'p') continue;
            car = this.lectureNombreLiteraux();
        } while ((car == 'c' || car == 'p') && (car = this.nextLine()) != '\uffff');
        return car;
    }

    private char lectureNombreLiteraux() throws IOException {
        char car = this.nextChiffre();
        if (car != '\uffff') {
            this.nbVars = car - 48;
            while ((car = (char)this.in.read()) >= '0' && car <= '9') {
                this.nbVars = 10 * this.nbVars + (car - 48);
            }
            car = this.nextChiffre();
            this.nbClauses = car - 48;
            while ((car = (char)this.in.read()) >= '0' && car <= '9') {
                this.nbClauses = 10 * this.nbClauses + (car - 48);
            }
            if (car != '\n' && car != '\uffff') {
                this.nextLine();
            }
        }
        return car;
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    private void ajouterClauses(char car) throws IOException, ContradictionException, ParseFormatException {
        VecInt lit = new VecInt();
        int val = 0;
        boolean neg = false;
        do {
            if (car == '-') {
                neg = true;
                car = (char)this.in.read();
            } else if (car == '+') {
                car = (char)this.in.read();
            } else {
                if (car < '0') throw new ParseFormatException("Unknown character " + car);
                if (car > '9') throw new ParseFormatException("Unknown character " + car);
                val = car - 48;
                car = (char)this.in.read();
            }
            while (car >= '0' && car <= '9') {
                val = val * 10 + car - 48;
                car = (char)this.in.read();
            }
            if (val == 0) {
                this.s.addClause(lit);
                lit.clear();
            } else {
                lit.push(neg ? -val : val);
                neg = false;
                val = 0;
            }
            if (car == '\uffff') continue;
            car = this.passerEspaces();
        } while (car != '\uffff');
        if (lit.isEmpty()) return;
        this.s.addClause(lit);
    }

    private char passerEspaces() throws IOException {
        char car;
        while ((car = (char)this.in.read()) == ' ' || car == '\n') {
        }
        return car;
    }

    private char nextLine() throws IOException {
        char car;
        while ((car = (char)this.in.read()) != '\n' && car != '\uffff') {
        }
        return car;
    }

    private char nextChiffre() throws IOException {
        char car;
        while ((car = (char)this.in.read()) < '0' || car > '9' && car != '\uffff') {
        }
        return car;
    }

    @Override
    public String decode(int[] model) {
        StringBuffer stb = new StringBuffer();
        int i = 0;
        while (i < model.length) {
            stb.append(model[i]);
            stb.append(" ");
            ++i;
        }
        stb.append("0");
        return stb.toString();
    }

    @Override
    public void decode(int[] model, PrintWriter out) {
        int i = 0;
        while (i < model.length) {
            out.print(model[i]);
            out.print(" ");
            ++i;
        }
        out.print("0");
    }
}

