/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.tools;

import java.io.ObjectInputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Map;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.IteratorInt;
import org.sat4j.specs.TimeoutException;

public class DimacsOutputSolver
implements ISolver {
    private static final long serialVersionUID = 1L;
    private transient PrintWriter out;
    private int nbvars;
    private int nbclauses;
    private boolean fixedNbClauses = false;
    private boolean firstConstr = true;

    public DimacsOutputSolver() {
        this(new PrintWriter(System.out, true));
    }

    public DimacsOutputSolver(PrintWriter pw) {
        this.out = pw;
    }

    private void readObject(ObjectInputStream stream) {
        this.out = new PrintWriter(System.out, true);
    }

    @Override
    public int newVar() {
        return 0;
    }

    @Override
    public int newVar(int howmany) {
        this.out.print("p cnf " + howmany);
        this.nbvars = howmany;
        return 0;
    }

    @Override
    public void setExpectedNumberOfClauses(int nb) {
        this.out.println(" " + nb);
        this.nbclauses = nb;
        this.fixedNbClauses = true;
    }

    @Override
    public IConstr addClause(IVecInt literals) throws ContradictionException {
        if (this.firstConstr) {
            if (!this.fixedNbClauses) {
                this.out.println(" XXXXXX");
            }
            this.firstConstr = false;
        }
        IteratorInt iterator = literals.iterator();
        while (iterator.hasNext()) {
            this.out.print(String.valueOf(iterator.next()) + " ");
        }
        this.out.println("0");
        return null;
    }

    @Override
    public boolean removeConstr(IConstr c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addAllClauses(IVec<IVecInt> clauses) throws ContradictionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public IConstr addAtMost(IVecInt literals, int degree) throws ContradictionException {
        if (degree > 1) {
            throw new UnsupportedOperationException("Not a clausal problem! degree " + degree);
        }
        assert (degree == 1);
        if (this.firstConstr) {
            if (!this.fixedNbClauses) {
                this.out.println("XXXXXX");
            }
            this.firstConstr = false;
        }
        int i = 0;
        while (i <= literals.size()) {
            int j = i + 1;
            while (j < literals.size()) {
                this.out.println(-literals.get(i) + " " + -literals.get(j) + " 0");
                ++j;
            }
            ++i;
        }
        return null;
    }

    @Override
    public IConstr addAtLeast(IVecInt literals, int degree) throws ContradictionException {
        if (degree > 1) {
            throw new UnsupportedOperationException("Not a clausal problem! degree " + degree);
        }
        assert (degree == 1);
        return this.addClause(literals);
    }

    @Override
    public void setTimeout(int t) {
    }

    @Override
    public void setTimeoutMs(long t) {
    }

    @Override
    public int getTimeout() {
        return 0;
    }

    @Override
    public void reset() {
        this.fixedNbClauses = false;
        this.firstConstr = true;
    }

    @Override
    public void printStat(PrintStream out, String prefix) {
    }

    @Override
    public void printStat(PrintWriter out, String prefix) {
    }

    @Override
    public Map<String, Number> getStat() {
        return null;
    }

    @Override
    public String toString(String prefix) {
        return "Dimacs output solver";
    }

    @Override
    public void clearLearntClauses() {
    }

    @Override
    public int[] model() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean model(int var) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isSatisfiable() throws TimeoutException {
        throw new TimeoutException("There is no real solver behind!");
    }

    @Override
    public boolean isSatisfiable(IVecInt assumps) throws TimeoutException {
        throw new TimeoutException("There is no real solver behind!");
    }

    @Override
    public int[] findModel() throws TimeoutException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int[] findModel(IVecInt assumps) throws TimeoutException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int nConstraints() {
        return this.nbclauses;
    }

    @Override
    public int nVars() {
        return this.nbvars;
    }

    @Override
    public void expireTimeout() {
    }

    @Override
    public boolean isSatisfiable(IVecInt assumps, boolean global) throws TimeoutException {
        throw new TimeoutException("There is no real solver behind!");
    }

    @Override
    public boolean isSatisfiable(boolean global) throws TimeoutException {
        throw new TimeoutException("There is no real solver behind!");
    }

    @Override
    public void printInfos(PrintWriter out, String prefix) {
    }

    @Override
    public void setTimeoutOnConflicts(int count) {
    }

    @Override
    public boolean isDBSimplificationAllowed() {
        return false;
    }

    @Override
    public void setDBSimplificationAllowed(boolean status) {
    }
}

