/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.tools;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Map;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.IteratorInt;
import org.sat4j.specs.TimeoutException;

public class DimacsStringSolver
implements ISolver {
    private static final long serialVersionUID = 1L;
    private StringBuffer out;
    private int nbvars;
    private int nbclauses;
    private boolean fixedNbClauses = false;
    private boolean firstConstr = true;
    private int firstCharPos;
    private final int initBuilderSize;

    public DimacsStringSolver() {
        this(16);
    }

    public DimacsStringSolver(int initSize) {
        this.out = new StringBuffer(initSize);
        this.initBuilderSize = initSize;
    }

    public StringBuffer getOut() {
        return this.out;
    }

    @Override
    public int newVar() {
        return 0;
    }

    @Override
    public int newVar(int howmany) {
        this.out.append("p cnf " + howmany);
        this.setNbVars(howmany);
        return howmany;
    }

    protected void setNbVars(int howmany) {
        this.nbvars = howmany;
    }

    @Override
    public void setExpectedNumberOfClauses(int nb) {
        this.out.append(" " + nb);
        this.nbclauses = nb;
        this.fixedNbClauses = true;
    }

    @Override
    public IConstr addClause(IVecInt literals) throws ContradictionException {
        if (this.firstConstr) {
            if (!this.fixedNbClauses) {
                this.firstCharPos = 7 + Integer.toString(this.nbvars).length();
                this.out.append("                    ");
                this.out.append("\n");
                this.nbclauses = 0;
            }
            this.firstConstr = false;
        }
        if (!this.fixedNbClauses) {
            ++this.nbclauses;
        }
        IteratorInt iterator = literals.iterator();
        while (iterator.hasNext()) {
            this.out.append(iterator.next()).append(" ");
        }
        this.out.append("0\n");
        return null;
    }

    @Override
    public boolean removeConstr(IConstr c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addAllClauses(IVec<IVecInt> clauses) throws ContradictionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public IConstr addAtMost(IVecInt literals, int degree) throws ContradictionException {
        if (degree > 1) {
            throw new UnsupportedOperationException("Not a clausal problem! degree " + degree);
        }
        assert (degree == 1);
        if (this.firstConstr) {
            if (!this.fixedNbClauses) {
                this.firstCharPos = 7 + Integer.toString(this.nbvars).length();
                this.out.append("                    ");
                this.out.append("\n");
                this.nbclauses = 0;
            }
            this.firstConstr = false;
        }
        int i = 0;
        while (i <= literals.size()) {
            int j = i + 1;
            while (j < literals.size()) {
                if (!this.fixedNbClauses) {
                    ++this.nbclauses;
                }
                this.out.append(-literals.get(i) + " " + -literals.get(j) + " 0\n");
                ++j;
            }
            ++i;
        }
        return null;
    }

    @Override
    public IConstr addAtLeast(IVecInt literals, int degree) throws ContradictionException {
        if (degree > 1) {
            throw new UnsupportedOperationException("Not a clausal problem! degree " + degree);
        }
        assert (degree == 1);
        return this.addClause(literals);
    }

    @Override
    public void setTimeout(int t) {
    }

    @Override
    public void setTimeoutMs(long t) {
    }

    @Override
    public int getTimeout() {
        return 0;
    }

    @Override
    public void reset() {
        this.fixedNbClauses = false;
        this.firstConstr = true;
        this.out = new StringBuffer(this.initBuilderSize);
    }

    @Override
    public void printStat(PrintStream out, String prefix) {
    }

    @Override
    public void printStat(PrintWriter out, String prefix) {
    }

    @Override
    public Map<String, Number> getStat() {
        return null;
    }

    @Override
    public String toString(String prefix) {
        return "Dimacs output solver";
    }

    @Override
    public void clearLearntClauses() {
    }

    @Override
    public int[] model() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean model(int var) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isSatisfiable() throws TimeoutException {
        throw new TimeoutException("There is no real solver behind!");
    }

    @Override
    public boolean isSatisfiable(IVecInt assumps) throws TimeoutException {
        throw new TimeoutException("There is no real solver behind!");
    }

    @Override
    public int[] findModel() throws TimeoutException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int[] findModel(IVecInt assumps) throws TimeoutException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int nConstraints() {
        return this.nbclauses;
    }

    @Override
    public int nVars() {
        return this.nbvars;
    }

    public String toString() {
        this.out.insert(this.firstCharPos, this.nbclauses);
        return this.out.toString();
    }

    @Override
    public void expireTimeout() {
    }

    @Override
    public boolean isSatisfiable(IVecInt assumps, boolean global) throws TimeoutException {
        throw new TimeoutException("There is no real solver behind!");
    }

    @Override
    public boolean isSatisfiable(boolean global) throws TimeoutException {
        throw new TimeoutException("There is no real solver behind!");
    }

    @Override
    public void printInfos(PrintWriter out, String prefix) {
    }

    @Override
    public void setTimeoutOnConflicts(int count) {
    }

    @Override
    public boolean isDBSimplificationAllowed() {
        return false;
    }

    @Override
    public void setDBSimplificationAllowed(boolean status) {
    }
}

