/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.tools;

import org.sat4j.core.VecInt;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;
import org.sat4j.tools.SolverDecorator;

public class GateTranslator
extends SolverDecorator<ISolver> {
    private static final long serialVersionUID = 1L;

    public GateTranslator(ISolver solver) {
        super(solver);
    }

    public void gateFalse(int y) throws ContradictionException {
        VecInt clause = new VecInt(2);
        clause.push(-y);
        this.processClause(clause);
    }

    public void gateTrue(int y) throws ContradictionException {
        VecInt clause = new VecInt(2);
        clause.push(y);
        this.processClause(clause);
    }

    public void ite(int y, int x1, int x2, int x3) throws ContradictionException {
        VecInt clause = new VecInt(5);
        clause.push(-y).push(-x1).push(x2);
        this.processClause(clause);
        clause.clear();
        clause.push(-y).push(x1).push(x3);
        this.processClause(clause);
        clause.clear();
        clause.push(-x1).push(-x2).push(y);
        this.processClause(clause);
        clause.clear();
        clause.push(x1).push(-x3).push(y);
        this.processClause(clause);
        clause.clear();
        clause.push(-x2).push(-x3).push(y);
        this.processClause(clause);
        clause.clear();
        clause.push(-y).push(x2).push(x3);
        this.processClause(clause);
    }

    public void and(int y, IVecInt literals) throws ContradictionException {
        VecInt clause = new VecInt(literals.size() + 2);
        clause.push(y);
        int i = 0;
        while (i < literals.size()) {
            clause.push(-literals.get(i));
            ++i;
        }
        this.processClause(clause);
        clause.clear();
        i = 0;
        while (i < literals.size()) {
            clause.clear();
            clause.push(-y);
            clause.push(literals.get(i));
            this.processClause(clause);
            ++i;
        }
    }

    public void and(int y, int x1, int x2) throws ContradictionException {
        VecInt clause = new VecInt(4);
        clause.push(-y);
        clause.push(x1);
        this.addClause(clause);
        clause.clear();
        clause.push(-y);
        clause.push(x2);
        this.addClause(clause);
        clause.clear();
        clause.push(y);
        clause.push(-x1);
        clause.push(-x2);
        this.addClause(clause);
    }

    public void or(int y, IVecInt literals) throws ContradictionException {
        VecInt clause = new VecInt(literals.size() + 2);
        literals.copyTo(clause);
        clause.push(-y);
        this.processClause(clause);
        clause.clear();
        int i = 0;
        while (i < literals.size()) {
            clause.clear();
            clause.push(y);
            clause.push(-literals.get(i));
            this.processClause(clause);
            ++i;
        }
    }

    private void processClause(IVecInt clause) throws ContradictionException {
        this.addClause(clause);
    }

    public void not(int y, int x) throws ContradictionException {
        VecInt clause = new VecInt(3);
        clause.push(-y).push(-x);
        this.processClause(clause);
        clause.clear();
        clause.push(y).push(x);
        this.processClause(clause);
    }

    public void xor(int y, IVecInt literals) throws ContradictionException {
        literals.push(-y);
        int[] f = new int[literals.size()];
        literals.copyTo(f);
        this.xor2Clause(f, 0, false);
    }

    public void iff(int y, IVecInt literals) throws ContradictionException {
        literals.push(y);
        int[] f = new int[literals.size()];
        literals.copyTo(f);
        this.iff2Clause(f, 0, false);
    }

    private void xor2Clause(int[] f, int prefix, boolean negation) throws ContradictionException {
        if (prefix == f.length - 1) {
            VecInt clause = new VecInt(f.length + 1);
            int i = 0;
            while (i < f.length - 1) {
                clause.push(f[i]);
                ++i;
            }
            clause.push(f[f.length - 1] * (negation ? -1 : 1));
            this.processClause(clause);
            return;
        }
        if (negation) {
            f[prefix] = -f[prefix];
            this.xor2Clause(f, prefix + 1, false);
            f[prefix] = -f[prefix];
            this.xor2Clause(f, prefix + 1, true);
        } else {
            this.xor2Clause(f, prefix + 1, false);
            f[prefix] = -f[prefix];
            this.xor2Clause(f, prefix + 1, true);
            f[prefix] = -f[prefix];
        }
    }

    private void iff2Clause(int[] f, int prefix, boolean negation) throws ContradictionException {
        if (prefix == f.length - 1) {
            VecInt clause = new VecInt(f.length + 1);
            int i = 0;
            while (i < f.length - 1) {
                clause.push(f[i]);
                ++i;
            }
            clause.push(f[f.length - 1] * (negation ? -1 : 1));
            this.processClause(clause);
            return;
        }
        if (negation) {
            this.iff2Clause(f, prefix + 1, false);
            f[prefix] = -f[prefix];
            this.iff2Clause(f, prefix + 1, true);
            f[prefix] = -f[prefix];
        } else {
            f[prefix] = -f[prefix];
            this.iff2Clause(f, prefix + 1, false);
            f[prefix] = -f[prefix];
            this.iff2Clause(f, prefix + 1, true);
        }
    }
}

