/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.tools;

import org.sat4j.core.VecInt;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.TimeoutException;
import org.sat4j.tools.SolverDecorator;

public class ModelIterator
extends SolverDecorator<ISolver> {
    private static final long serialVersionUID = 1L;
    private boolean trivialfalsity = false;

    public ModelIterator(ISolver solver) {
        super(solver);
    }

    @Override
    public int[] model() {
        int[] last = super.model();
        VecInt clause = new VecInt(last.length);
        int[] nArray = last;
        int n = last.length;
        int n2 = 0;
        while (n2 < n) {
            int q = nArray[n2];
            clause.push(-q);
            ++n2;
        }
        try {
            this.addClause(clause);
        }
        catch (ContradictionException e) {
            this.trivialfalsity = true;
        }
        return last;
    }

    @Override
    public boolean isSatisfiable() throws TimeoutException {
        if (this.trivialfalsity) {
            return false;
        }
        this.trivialfalsity = false;
        return super.isSatisfiable();
    }

    @Override
    public boolean isSatisfiable(IVecInt assumps) throws TimeoutException {
        if (this.trivialfalsity) {
            return false;
        }
        this.trivialfalsity = false;
        return super.isSatisfiable(assumps);
    }

    @Override
    public void reset() {
        this.trivialfalsity = false;
        super.reset();
    }
}

