/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.tools;

import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IOptimizationProblem;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.TimeoutException;
import org.sat4j.tools.SolverDecorator;

public class OptToSatAdapter
extends SolverDecorator<ISolver> {
    private static final long serialVersionUID = 1L;
    IOptimizationProblem problem;
    boolean modelComputed = false;

    public OptToSatAdapter(IOptimizationProblem problem) {
        super((ISolver)((Object)problem));
        this.problem = problem;
    }

    @Override
    public boolean isSatisfiable() throws TimeoutException {
        this.modelComputed = false;
        return this.problem.admitABetterSolution();
    }

    @Override
    public boolean isSatisfiable(boolean global) throws TimeoutException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isSatisfiable(IVecInt assumps, boolean global) throws TimeoutException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isSatisfiable(IVecInt assumps) throws TimeoutException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int[] model() {
        if (this.modelComputed) {
            return this.problem.model();
        }
        try {
            assert (this.problem.admitABetterSolution());
            do {
                this.problem.calculateObjective();
                this.problem.discard();
            } while (this.problem.admitABetterSolution());
        }
        catch (TimeoutException timeoutException) {
        }
        catch (ContradictionException contradictionException) {
            // empty catch block
        }
        this.modelComputed = true;
        return this.problem.model();
    }

    @Override
    public boolean model(int var) {
        if (!this.modelComputed) {
            this.model();
        }
        return this.problem.model(var);
    }

    @Override
    public String toString(String prefix) {
        return String.valueOf(prefix) + "Optimization to SAT adapter\n" + super.toString(prefix);
    }
}

