/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.tools;

import org.sat4j.core.VecInt;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.TimeoutException;
import org.sat4j.tools.SolverDecorator;

public class SingleSolutionDetector
extends SolverDecorator<ISolver> {
    private static final long serialVersionUID = 1L;

    public SingleSolutionDetector(ISolver solver) {
        super(solver);
    }

    public boolean hasASingleSolution() throws TimeoutException {
        return this.hasASingleSolution(new VecInt());
    }

    public boolean hasASingleSolution(IVecInt assumptions) throws TimeoutException {
        int[] firstmodel = this.model();
        assert (firstmodel != null);
        VecInt clause = new VecInt(firstmodel.length);
        int[] nArray = firstmodel;
        int n = firstmodel.length;
        int n2 = 0;
        while (n2 < n) {
            int q = nArray[n2];
            clause.push(-q);
            ++n2;
        }
        boolean result = false;
        try {
            IConstr added = this.addClause(clause);
            result = !this.isSatisfiable(assumptions);
            this.removeConstr(added);
        }
        catch (ContradictionException e) {
            result = true;
        }
        return result;
    }
}

