/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import org.sat4j.ExitCode;
import org.sat4j.Lanceur;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.reader.Reader;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IProblem;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.TimeoutException;

public abstract class AbstractLauncher {
    public static final String SOLUTION_PREFIX = "v ";
    public static final String ANSWER_PREFIX = "s ";
    public static final String COMMENT_PREFIX = "c ";
    protected long begintime;
    protected ExitCode exitcode = ExitCode.UNKNOWN;
    protected Reader reader;
    protected Thread shutdownHook = new Thread(){

        public void run() {
            AbstractLauncher.this.displayResult(AbstractLauncher.this.solver, AbstractLauncher.this.begintime, AbstractLauncher.this.exitcode);
        }
    };
    protected ISolver solver;

    protected AbstractLauncher() {
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
    }

    protected abstract void displayResult(ISolver var1, long var2, ExitCode var4);

    protected abstract void usage();

    private void displayHeader() throws IOException {
        Object object;
        this.log("SAT4J: a SATisfiability library for Java (c) 2004-2006 Daniel Le Berre");
        this.log("This is free software under the GNU LGPL licence. See www.sat4j.org for details.");
        URL uRL = Lanceur.class.getResource("/sat4j.version");
        if (uRL != null) {
            object = new BufferedReader(new InputStreamReader(uRL.openStream()));
            this.log("version " + ((BufferedReader)object).readLine());
            ((BufferedReader)object).close();
        } else {
            this.log("no version file found!!!");
        }
        object = System.getProperties();
        for (Map.Entry<Object, Object> entry : ((Properties)object).entrySet()) {
            if ("line.separator".equals(entry.getKey())) continue;
            this.log(entry.toString());
        }
        Runtime runtime = Runtime.getRuntime();
        this.log("Free memory " + runtime.freeMemory());
        this.log("Max memory " + runtime.maxMemory());
        this.log("Total memory " + runtime.totalMemory());
        this.log("Number of processors " + runtime.availableProcessors());
    }

    protected IProblem readProblem(String string, ISolver iSolver, long l) throws FileNotFoundException, ParseFormatException, IOException, ContradictionException {
        this.log("solving " + string);
        this.log("reading problem ... ");
        this.reader = this.createReader(iSolver);
        IProblem iProblem = this.reader.parseInstance(string);
        this.log("... done. Time " + (double)(System.currentTimeMillis() - l) / 1000.0 + " ms.");
        this.log("#vars     " + iSolver.nVars());
        this.log("#constraints  " + iSolver.nConstraints());
        return iProblem;
    }

    protected abstract Reader createReader(ISolver var1);

    public void run(String[] stringArray) {
        try {
            this.displayHeader();
            this.solver = this.configureSolver(stringArray);
            String string = this.getInstanceName(stringArray);
            this.begintime = System.currentTimeMillis();
            IProblem iProblem = this.readProblem(string, this.solver, this.begintime);
            try {
                this.solve(iProblem);
            }
            catch (TimeoutException timeoutException) {
                this.log("timeout");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (ContradictionException contradictionException) {
            this.exitcode = ExitCode.UNSATISFIABLE;
            this.log("(trivial inconsistency)");
        }
        catch (ParseFormatException parseFormatException) {
            parseFormatException.printStackTrace();
        }
        System.exit(this.exitcode.value());
    }

    protected abstract String getInstanceName(String[] var1);

    protected abstract ISolver configureSolver(String[] var1);

    protected void log(String string) {
        System.out.println(COMMENT_PREFIX + string);
    }

    protected void solve(IProblem iProblem) throws TimeoutException {
        boolean bl = iProblem.isSatisfiable();
        this.exitcode = bl ? ExitCode.SATISFIABLE : ExitCode.UNSATISFIABLE;
    }
}

