/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j;

import org.sat4j.AbstractLauncher;
import org.sat4j.ExitCode;
import org.sat4j.minisat.SolverFactory;
import org.sat4j.reader.CSPExtSupportReader;
import org.sat4j.reader.Reader;
import org.sat4j.specs.ISolver;

public class CSPLauncher
extends AbstractLauncher {
    protected ISolver configureSolver(String[] stringArray) {
        return SolverFactory.newMiniSAT2Heap();
    }

    protected Reader createReader(ISolver iSolver) {
        return new CSPExtSupportReader(iSolver);
    }

    protected void displayResult(ISolver iSolver, long l, ExitCode exitCode) {
        switch (exitCode) {
            case SATISFIABLE: {
                System.out.println("SAT");
                int[] nArray = iSolver.model();
                System.out.println(this.reader.decode(nArray));
                break;
            }
            case UNSATISFIABLE: {
                System.out.println("UNSAT");
                break;
            }
        }
        System.out.println("c  Total ellapsed CPU time (wall clock):" + (double)(System.currentTimeMillis() - l) / 1000.0);
    }

    public static void main(String[] stringArray) {
        CSPLauncher cSPLauncher = new CSPLauncher();
        cSPLauncher.run(stringArray);
    }

    protected void usage() {
        System.out.println("java -jar sat4jCSP instance-name-without-suffix");
    }

    protected String getInstanceName(String[] stringArray) {
        assert (stringArray.length == 1);
        stringArray[0] = stringArray[0] + ".txt";
        return stringArray[0];
    }
}

