/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j;

import org.apache.commons.beanutils.BeanUtils;
import org.sat4j.AbstractLauncher;
import org.sat4j.ExitCode;
import org.sat4j.Messages;
import org.sat4j.core.ASolverFactory;
import org.sat4j.reader.InstanceReader;
import org.sat4j.reader.Reader;
import org.sat4j.specs.ISolver;

public class Lanceur
extends AbstractLauncher {
    protected ASolverFactory factory;
    protected int argindex = 0;

    public static void main(String[] stringArray) {
        Lanceur lanceur = new Lanceur();
        lanceur.run(stringArray);
    }

    protected ISolver configureSolver(String[] stringArray) {
        ISolver iSolver;
        if (stringArray.length < 1) {
            this.usage();
            System.exit(-1);
        }
        String string = "minisat";
        if (stringArray[0].equals("-l")) {
            assert (stringArray[1].equals("minisat") || stringArray[1].equals("ubcsat"));
            string = stringArray[1];
            this.argindex += 2;
        }
        try {
            this.factory = (ASolverFactory)Class.forName("org.sat4j." + string + ".SolverFactory").newInstance();
        }
        catch (Exception exception) {
            System.err.println(Messages.getString("Lanceur.wrong.framework"));
            exception.printStackTrace();
        }
        if (stringArray.length < this.argindex + 1) {
            this.usage();
            System.exit(-1);
        }
        if (stringArray.length == this.argindex + 1) {
            iSolver = this.factory.defaultSolver();
        } else {
            iSolver = this.factory.createSolverByName(stringArray[this.argindex++]);
            for (int i = this.argindex + 1; stringArray.length > i; ++i) {
                String[] stringArray2 = stringArray[i].split("=");
                assert (stringArray2.length == 2);
                this.log("setting " + stringArray2[0] + " to " + stringArray2[1]);
                try {
                    BeanUtils.setProperty(iSolver, stringArray2[0], stringArray2[1]);
                    continue;
                }
                catch (Exception exception) {
                    this.log("Cannot set parameter : " + stringArray[i]);
                }
            }
        }
        System.out.println(iSolver.toString("c "));
        this.log("timeout: " + iSolver.getTimeout() + "s");
        return iSolver;
    }

    protected Reader createReader(ISolver iSolver) {
        return new InstanceReader(iSolver);
    }

    protected void displayResult(ISolver iSolver, long l, ExitCode exitCode) {
        if (iSolver != null) {
            double d = (double)(System.currentTimeMillis() - l) / 1000.0;
            iSolver.printStat(System.out, "c ");
            System.out.println("s " + (Object)((Object)exitCode));
            if (exitCode == ExitCode.SATISFIABLE) {
                int[] nArray = iSolver.model();
                System.out.println("v " + this.reader.decode(nArray));
            }
            this.log("c Total CPU time (ms) : " + d);
        }
    }

    void showAvailableSolvers() {
        if (this.factory != null) {
            System.out.println("Available solvers: ");
            String[] stringArray = this.factory.solverNames();
            for (int i = 0; i < stringArray.length; ++i) {
                System.out.println(stringArray[i]);
            }
        }
    }

    protected void usage() {
        System.out.println("Usage: java -jar sat4j.jar -l [minisat|ubcsat] [<solver>] <cnffile> [<timeout>]");
        this.showAvailableSolvers();
    }

    protected String getInstanceName(String[] stringArray) {
        return stringArray[this.argindex];
    }
}

